/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.config;

import com.dangdang.ddframe.job.lite.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public final class RescheduleListenerManager
extends AbstractListenerManager {
    private final ConfigurationNode configNode;
    private final String jobName;

    public RescheduleListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.configNode = new ConfigurationNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new CronSettingAndJobEventChangedJobListener());
    }

    class CronSettingAndJobEventChangedJobListener
    extends AbstractJobListener {
        CronSettingAndJobEventChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (RescheduleListenerManager.this.configNode.isConfigPath(path) && TreeCacheEvent.Type.NODE_UPDATED == eventType && !JobRegistry.getInstance().isShutdown(RescheduleListenerManager.this.jobName)) {
                JobRegistry.getInstance().getJobScheduleController(RescheduleListenerManager.this.jobName).rescheduleJob(LiteJobConfigurationGsonFactory.fromJson(data).getTypeConfig().getCoreConfig().getCron());
            }
        }
    }
}

