/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.util.MemoryManagerAdminMBean;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class MemoryManager<T>
implements MemoryManagerAdminMBean {
    private static final Logger log = Logger.getLogger((String)MemoryManager.class.getName());
    private static final int[] sizetable;
    private final AtomicLong _hits = new AtomicLong(0L);
    private final AtomicLong _miss = new AtomicLong(0L);
    private final ConcurrentHashMap<Integer, ConcurrentLinkedQueue<WeakReference<T>>> _sizeMap = new ConcurrentHashMap();
    private volatile ConcurrentLinkedQueue<T> _releaseQueue = new ConcurrentLinkedQueue();
    private volatile ConcurrentLinkedQueue<T> _releaseQueueb = new ConcurrentLinkedQueue();
    private final AtomicInteger _releaseQueueSize = new AtomicInteger(0);
    private final Initializer<T> _initializer;
    private final Thread _cleanThread;

    public MemoryManager(Initializer<T> initializer) {
        this._initializer = initializer;
        this._cleanThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object buf = null;
                while (true) {
                    MemoryManager memoryManager = MemoryManager.this;
                    synchronized (memoryManager) {
                        try {
                            MemoryManager.this.wait(10L);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e);
                        }
                    }
                    ConcurrentLinkedQueue t = MemoryManager.this._releaseQueue;
                    MemoryManager.this._releaseQueue = MemoryManager.this._releaseQueueb;
                    MemoryManager.this._releaseQueueb = t;
                    while (true) {
                        Object e = MemoryManager.this._releaseQueueb.poll();
                        buf = e;
                        if (e == null) break;
                        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)MemoryManager.this._sizeMap.get(MemoryManager.this._initializer.size(buf));
                        MemoryManager.this._initializer.init(buf);
                        queue.offer(new WeakReference<Object>(buf));
                        MemoryManager.this._releaseQueueSize.decrementAndGet();
                    }
                    buf = null;
                }
            }
        });
        this._cleanThread.setDaemon(true);
        this._cleanThread.start();
    }

    public MemoryManagerAdminMBean getAdminMBean() {
        return this;
    }

    @Override
    public long getNumCacheMisses() {
        return this._miss.get();
    }

    @Override
    public long getNumCacheHits() {
        return this._hits.get();
    }

    @Override
    public double getHitRate() {
        long miss = this._miss.get();
        long hit = this._hits.get();
        return (double)hit / (double)(hit + miss);
    }

    public T get(int reqsize) {
        return this._initializer.newInstance(reqsize);
    }

    public void release(T buf) {
    }

    static {
        int initsize = 1024;
        double ratio = 1.3;
        int l = (int)(Math.log(Integer.MAX_VALUE / initsize) / Math.log(ratio)) + 1;
        sizetable = new int[l];
        MemoryManager.sizetable[0] = initsize;
        for (int i = 1; i < sizetable.length; ++i) {
            MemoryManager.sizetable[i] = (int)((double)sizetable[i - 1] * ratio);
        }
    }

    public static interface Initializer<E> {
        public E newInstance(int var1);

        public int size(E var1);

        public void init(E var1);
    }
}

