/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.service;

import com.browseengine.bobo.docidset.AndDocIdSet;
import com.browseengine.bobo.docidset.ImmutableDocSet;
import com.browseengine.bobo.docidset.NotDocIdSet;
import com.browseengine.bobo.docidset.OrDocIdSet;
import com.browseengine.bobo.service.BrowseQueryParser;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSet;

public class DefaultBrowseQueryParser
implements BrowseQueryParser {
    @Override
    public DocIdSet parse(BrowseQueryParser.SelectionNode[] selectionNodes, BrowseQueryParser.SelectionNode[] notSelectionNodes, int maxDoc) {
        ImmutableDocSet docSet = null;
        ImmutableDocSet selSet = null;
        if (selectionNodes != null && selectionNodes.length > 0) {
            ArrayList<DocIdSet> selSetList = new ArrayList<DocIdSet>(selectionNodes.length);
            for (BrowseQueryParser.SelectionNode selectionNode : selectionNodes) {
                DocIdSet ds = selectionNode.getDocSet();
                if (ds == null) continue;
                selSetList.add(ds);
            }
            if (selSetList.size() > 0) {
                selSet = selSetList.size() == 1 ? (DocIdSet)selSetList.get(0) : new AndDocIdSet(selSetList);
            }
        }
        ImmutableDocSet notSelSet = null;
        if (notSelectionNodes != null && notSelectionNodes.length > 0) {
            ArrayList<DocIdSet> notSelSetList = new ArrayList<DocIdSet>(notSelectionNodes.length);
            for (BrowseQueryParser.SelectionNode selectionNode : notSelectionNodes) {
                DocIdSet ds = selectionNode.getDocSet();
                if (ds != null) {
                    notSelSetList.add(ds);
                }
                if (notSelSetList.size() <= 0) continue;
                notSelSet = notSelSetList.size() == 1 ? (DocIdSet)notSelSetList.get(0) : new OrDocIdSet(notSelSetList);
            }
        }
        if (notSelSet != null) {
            notSelSet = new NotDocIdSet(notSelSet, maxDoc);
        }
        if (selSet != null && notSelSet != null) {
            DocIdSet[] sets = new DocIdSet[]{selSet, notSelSet};
            docSet = new AndDocIdSet(Arrays.asList(sets));
        } else if (selSet != null) {
            docSet = selSet;
        } else if (notSelSet != null) {
            docSet = notSelSet;
        }
        return docSet;
    }
}

