/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search.section;

import com.browseengine.bobo.search.section.MetaDataCache;
import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;

public class IntMetaDataCache
implements MetaDataCache {
    private static final int MAX_SLOTS = 1024;
    private static final int MISSING = Integer.MIN_VALUE;
    private final AtomicReader _reader;
    private final int[][] _list;
    private int _curPageNo;
    private int[] _curPage;
    private int _curSlot;
    private int _curData;

    public IntMetaDataCache(Term term, AtomicReader reader) throws IOException {
        this._reader = reader;
        int maxDoc = reader.maxDoc();
        this._list = new int[(maxDoc + 1024 - 1) / 1024][];
        this._curPageNo = 0;
        this._curSlot = 0;
        this._curData = 1024;
        if (maxDoc > 0) {
            this._curPage = new int[2048];
            this.loadPayload(term);
        }
        this._curPage = null;
    }

    protected void add(int docid, byte[] data, int blen) {
        int pageNo = docid / 1024;
        if (pageNo != this._curPageNo) {
            while (this._curSlot < 1024) {
                this._curPage[this._curSlot++] = Integer.MIN_VALUE;
            }
            this._list[this._curPageNo++] = this.copyPage(new int[this._curData]);
            this._curSlot = 0;
            this._curData = 1024;
            while (this._curPageNo < pageNo) {
                this._list[this._curPageNo++] = null;
            }
        }
        while (this._curSlot < docid % 1024) {
            this._curPage[this._curSlot++] = Integer.MIN_VALUE;
        }
        if (blen <= 4) {
            int val = 0;
            if (blen == 0) {
                val = Integer.MIN_VALUE;
            } else {
                for (int i = 0; i < 4 && i < data.length; ++i) {
                    val |= (data[i] & 0xFF) << i * 8;
                }
            }
            if (val >= 0) {
                this._curPage[this._curSlot] = val;
            } else {
                this.appendToTail(data, blen);
            }
        } else {
            this.appendToTail(data, blen);
        }
        ++this._curSlot;
    }

    private void appendToTail(byte[] data, int blen) {
        int ilen = (blen + 3) / 4;
        if (this._curPage.length <= this._curData + ilen) {
            this._curPage = this.copyPage(new int[this._curPage.length + Math.max(this._curPage.length - 1024, ilen)]);
        }
        this._curPage[this._curSlot] = -this._curData;
        this._curData = this.copyByteToInt(data, 0, blen, this._curPage, this._curData);
    }

    private int copyByteToInt(byte[] src, int off, int blen, int[] dst, int dstoff) {
        while (blen > 0) {
            int val = 0;
            for (int i = 0; i < 4; ++i) {
                --blen;
                if (off >= src.length) break;
                val |= (src[off++] & 0xFF) << i * 8;
            }
            dst[dstoff++] = val;
        }
        return dstoff;
    }

    private int[] copyPage(int[] dst) {
        System.arraycopy(this._curPage, 0, dst, 0, this._curData);
        return dst;
    }

    protected void loadPayload(Term term) throws IOException {
        DocsAndPositionsEnum dp = this._reader.termPositionsEnum(term);
        int docID = -1;
        while ((docID = dp.nextDoc()) != Integer.MAX_VALUE) {
            if (dp.freq() <= 0) continue;
            dp.nextPosition();
            BytesRef payload = dp.getPayload();
            if (payload == null) continue;
            this.add(docID, payload.bytes, payload.length);
        }
        while (this._curSlot < 1024) {
            this._curPage[this._curSlot++] = Integer.MIN_VALUE;
        }
        this._list[this._curPageNo] = this.copyPage(new int[this._curData]);
        this._curPage = null;
    }

    public int getValue(int docid, int idx, int defaultValue) {
        int[] page = this._list[docid / 1024];
        if (page == null) {
            return defaultValue;
        }
        int val = page[docid % 1024];
        if (val >= 0) {
            return val;
        }
        return val == Integer.MIN_VALUE ? defaultValue : page[idx - val];
    }

    public int getNumItems(int docid) {
        int[] page = this._list[docid / 1024];
        if (page == null) {
            return 0;
        }
        int slotNo = docid % 1024;
        int val = page[slotNo];
        if (val >= 0) {
            return 1;
        }
        if (val == Integer.MIN_VALUE) {
            return 0;
        }
        ++slotNo;
        while (slotNo < 1024) {
            int nextVal;
            if ((nextVal = page[slotNo++]) >= 0 || nextVal == Integer.MIN_VALUE) continue;
            return val - nextVal;
        }
        return val + page.length;
    }

    public int maxDoc() {
        return this._reader.maxDoc();
    }
}

