/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search;

import com.browseengine.bobo.api.BoboMultiReader;
import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.mapred.BoboMapFunctionWrapper;
import com.browseengine.bobo.search.FacetHitCollector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.AtomicReaderContextUtil;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class BoboSearcher
extends IndexSearcher {
    protected List<FacetHitCollector> _facetCollectors = new LinkedList<FacetHitCollector>();
    protected BoboSegmentReader[] _subReaders;

    public BoboSearcher(BoboSegmentReader reader) {
        super((IndexReader)reader);
        ArrayList<BoboSegmentReader> readerList = new ArrayList<BoboSegmentReader>();
        readerList.add(reader);
        this._subReaders = readerList.toArray(new BoboSegmentReader[readerList.size()]);
    }

    public BoboSearcher(BoboMultiReader reader) {
        super((IndexReader)reader);
        List<BoboSegmentReader> subReaders = reader.getSubReaders();
        this._subReaders = subReaders.toArray(new BoboSegmentReader[subReaders.size()]);
    }

    public void setFacetHitCollectorList(List<FacetHitCollector> facetHitCollectors) {
        if (facetHitCollectors != null) {
            this._facetCollectors = facetHitCollectors;
        }
    }

    protected FacetValidator createFacetValidator() throws IOException {
        FacetHitCollector[] collectors = new FacetHitCollector[this._facetCollectors.size()];
        FacetCountCollectorSource[] countCollectors = new FacetCountCollectorSource[collectors.length];
        int i = 0;
        int j = collectors.length;
        for (FacetHitCollector facetCollector : this._facetCollectors) {
            if (facetCollector._filter != null) {
                collectors[i] = facetCollector;
                countCollectors[i] = facetCollector._facetCountCollectorSource;
                ++i;
                continue;
            }
            collectors[--j] = facetCollector;
            countCollectors[j] = facetCollector._facetCountCollectorSource;
        }
        int numPostFilters = i;
        if (numPostFilters == 0) {
            return new NoNeedFacetValidator(collectors);
        }
        if (numPostFilters == 1) {
            return new OnePostFilterFacetValidator(collectors);
        }
        return new DefaultFacetValidator(collectors, numPostFilters);
    }

    public void search(Query query, Filter filter, Collector collector) throws IOException {
        Weight weight = this.createNormalizedWeight(query);
        this.search(weight, filter, collector, 0, null);
    }

    public void search(Weight weight, Filter filter, Collector collector, int start, BoboMapFunctionWrapper mapReduceWrapper) throws IOException {
        FacetValidator validator = this.createFacetValidator();
        int target = 0;
        IndexReader reader = this.getIndexReader();
        IndexReaderContext indexReaderContext = reader.getContext();
        if (filter == null) {
            for (int i = 0; i < this._subReaders.length; ++i) {
                AtomicReaderContext atomicContext = indexReaderContext.children() == null ? (AtomicReaderContext)indexReaderContext : (AtomicReaderContext)indexReaderContext.children().get(i);
                int docStart = start;
                atomicContext = AtomicReaderContextUtil.updateDocBase(atomicContext, docStart);
                if (reader instanceof BoboMultiReader) {
                    docStart = start + ((BoboMultiReader)reader).subReaderBase(i);
                }
                collector.setNextReader(atomicContext);
                validator.setNextReader(this._subReaders[i], docStart);
                Scorer scorer = weight.scorer(atomicContext, true, true, this._subReaders[i].getLiveDocs());
                if (scorer != null) {
                    collector.setScorer(scorer);
                    target = scorer.nextDoc();
                    while (target != Integer.MAX_VALUE) {
                        if (validator.validate(target)) {
                            collector.collect(target);
                            target = scorer.nextDoc();
                            continue;
                        }
                        target = validator._nextTarget;
                        target = scorer.advance(target);
                    }
                }
                if (mapReduceWrapper == null) continue;
                mapReduceWrapper.mapFullIndexReader(this._subReaders[i], validator.getCountCollectors());
            }
            return;
        }
        block2: for (int i = 0; i < this._subReaders.length; ++i) {
            AtomicReaderContext atomicContext = indexReaderContext.children() == null ? (AtomicReaderContext)indexReaderContext : (AtomicReaderContext)indexReaderContext.children().get(i);
            DocIdSet filterDocIdSet = filter.getDocIdSet(atomicContext, this._subReaders[i].getLiveDocs());
            if (filterDocIdSet == null) {
                return;
            }
            int docStart = start;
            if (reader instanceof BoboMultiReader) {
                docStart = start + ((BoboMultiReader)reader).subReaderBase(i);
            }
            collector.setNextReader(atomicContext);
            validator.setNextReader(this._subReaders[i], docStart);
            Scorer scorer = weight.scorer(atomicContext, true, false, this._subReaders[i].getLiveDocs());
            if (scorer == null) continue;
            collector.setScorer(scorer);
            DocIdSetIterator filterDocIdIterator = filterDocIdSet.iterator();
            if (filterDocIdIterator == null) continue;
            int doc = -1;
            target = filterDocIdIterator.nextDoc();
            if (mapReduceWrapper == null) {
                while (target < Integer.MAX_VALUE) {
                    if (doc < target) {
                        doc = scorer.advance(target);
                    }
                    if (doc == target) {
                        if (validator.validate(doc)) {
                            collector.collect(doc);
                            target = filterDocIdIterator.nextDoc();
                            continue;
                        }
                        target = filterDocIdIterator.advance(validator._nextTarget);
                        continue;
                    }
                    if (doc == Integer.MAX_VALUE) continue block2;
                    target = filterDocIdIterator.advance(doc);
                }
                continue;
            }
            while (target < Integer.MAX_VALUE) {
                if (doc < target) {
                    doc = scorer.advance(target);
                }
                if (doc == target) {
                    if (validator.validate(doc)) {
                        mapReduceWrapper.mapSingleDocument(doc, this._subReaders[i]);
                        collector.collect(doc);
                        target = filterDocIdIterator.nextDoc();
                        continue;
                    }
                    target = filterDocIdIterator.advance(validator._nextTarget);
                    continue;
                }
                if (doc == Integer.MAX_VALUE) break;
                target = filterDocIdIterator.advance(doc);
            }
            mapReduceWrapper.finalizeSegment(this._subReaders[i], validator.getCountCollectors());
        }
    }

    private static final class NoNeedFacetValidator
    extends FacetValidator {
        NoNeedFacetValidator(FacetHitCollector[] collectors) throws IOException {
            super(collectors, 0);
        }

        @Override
        public final boolean validate(int docid) throws IOException {
            for (FacetCountCollector collector : this._countCollectors) {
                collector.collect(docid);
            }
            return true;
        }
    }

    private static final class OnePostFilterFacetValidator
    extends FacetValidator {
        private final FacetHitCollector _firsttime;

        OnePostFilterFacetValidator(FacetHitCollector[] collectors) throws IOException {
            super(collectors, 1);
            this._firsttime = this._collectors[0];
        }

        @Override
        public final boolean validate(int docid) throws IOException {
            FacetHitCollector.CurrentPointers miss = null;
            RandomAccessDocIdSet set = this._firsttime._currentPointers.docidSet;
            if (set != null && !set.get(docid)) {
                miss = this._firsttime._currentPointers;
            }
            this._nextTarget = docid + 1;
            if (miss != null) {
                miss.facetCountCollector.collect(docid);
                return false;
            }
            for (FacetCountCollector collector : this._countCollectors) {
                collector.collect(docid);
            }
            return true;
        }
    }

    private static final class DefaultFacetValidator
    extends FacetValidator {
        public DefaultFacetValidator(FacetHitCollector[] collectors, int numPostFilters) throws IOException {
            super(collectors, numPostFilters);
        }

        @Override
        public final boolean validate(int docid) throws IOException {
            FacetHitCollector.CurrentPointers miss = null;
            for (int i = 0; i < this._numPostFilters; ++i) {
                FacetHitCollector.CurrentPointers cur = this._collectors[i]._currentPointers;
                int sid = cur.doc;
                if (sid < docid) {
                    cur.doc = sid = cur.postDocIDSetIterator.advance(docid);
                    if (sid == Integer.MAX_VALUE) {
                        FacetHitCollector tmp = this._collectors[0];
                        this._collectors[0] = this._collectors[i];
                        this._collectors[i] = tmp;
                    }
                }
                if (sid <= docid) continue;
                if (miss != null) {
                    this._nextTarget = miss.doc < cur.doc ? miss.doc : cur.doc;
                    return false;
                }
                miss = cur;
            }
            this._nextTarget = docid + 1;
            if (miss != null) {
                miss.facetCountCollector.collect(docid);
                return false;
            }
            for (FacetCountCollector collector : this._countCollectors) {
                collector.collect(docid);
            }
            return true;
        }
    }

    static abstract class FacetValidator {
        protected final FacetHitCollector[] _collectors;
        protected final int _numPostFilters;
        protected FacetCountCollector[] _countCollectors;
        public int _nextTarget;

        private void sortPostCollectors(final BoboSegmentReader reader) {
            Comparator<FacetHitCollector> comparator = new Comparator<FacetHitCollector>(){

                @Override
                public int compare(FacetHitCollector fhc1, FacetHitCollector fhc2) {
                    double selectivity2;
                    double selectivity1 = fhc1._filter.getFacetSelectivity(reader);
                    if (selectivity1 < (selectivity2 = fhc2._filter.getFacetSelectivity(reader))) {
                        return -1;
                    }
                    if (selectivity1 > selectivity2) {
                        return 1;
                    }
                    return 0;
                }
            };
            Arrays.sort(this._collectors, 0, this._numPostFilters, comparator);
        }

        public FacetValidator(FacetHitCollector[] collectors, int numPostFilters) throws IOException {
            this._collectors = collectors;
            this._numPostFilters = numPostFilters;
            this._countCollectors = new FacetCountCollector[collectors.length];
        }

        public abstract boolean validate(int var1) throws IOException;

        public void setNextReader(BoboSegmentReader reader, int docBase) throws IOException {
            ArrayList<FacetCountCollector> collectorList = new ArrayList<FacetCountCollector>();
            this.sortPostCollectors(reader);
            for (int i = 0; i < this._collectors.length; ++i) {
                this._collectors[i].setNextReader(reader, docBase);
                FacetCountCollector collector = this._collectors[i]._currentPointers.facetCountCollector;
                if (collector == null) continue;
                collectorList.add(collector);
            }
            this._countCollectors = collectorList.toArray(new FacetCountCollector[collectorList.size()]);
        }

        public FacetCountCollector[] getCountCollectors() {
            ArrayList<FacetCountCollector> collectors = new ArrayList<FacetCountCollector>();
            collectors.addAll(Arrays.asList(this._countCollectors));
            for (FacetHitCollector facetHitCollector : this._collectors) {
                collectors.addAll(facetHitCollector._collectAllCollectorList);
                collectors.addAll(facetHitCollector._countCollectorList);
            }
            return collectors.toArray(new FacetCountCollector[collectors.size()]);
        }
    }
}

