/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermLongList;
import com.browseengine.bobo.query.ScorerBuilder;
import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;

public class RecencyBoostScorerBuilder
implements ScorerBuilder {
    private final float _maxFactor;
    private final TimeUnit _timeunit;
    private final float _min;
    private final float _max;
    private final long _cutoffInMillis;
    private final float _A;
    private final String _timeFacetName;
    private final long _now;

    public RecencyBoostScorerBuilder(String timeFacetName, float maxFactor, long cutoff, TimeUnit timeunit) {
        this(timeFacetName, maxFactor, timeunit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS), cutoff, timeunit);
    }

    public RecencyBoostScorerBuilder(String timeFacetName, float maxFactor, long from, long cutoff, TimeUnit timeunit) {
        this._timeFacetName = timeFacetName;
        this._maxFactor = maxFactor;
        this._min = 1.0f;
        this._max = this._maxFactor + this._min;
        this._timeunit = timeunit;
        this._cutoffInMillis = this._timeunit.toMillis(cutoff);
        this._A = (this._min - this._max) / ((float)this._cutoffInMillis * (float)this._cutoffInMillis);
        this._now = timeunit.toMillis(from);
    }

    @Override
    public Explanation explain(AtomicReader reader, int doc, Explanation innerExplaination) throws IOException {
        if (reader instanceof BoboSegmentReader) {
            BoboSegmentReader boboReader = (BoboSegmentReader)reader;
            Object dataObj = boboReader.getFacetData(this._timeFacetName);
            if (dataObj instanceof FacetDataCache) {
                FacetDataCache facetDataCache = (FacetDataCache)boboReader.getFacetData(this._timeFacetName);
                BigSegmentedArray orderArray = facetDataCache.orderArray;
                TermLongList termList = (TermLongList)facetDataCache.valArray;
                Explanation finalExpl = new Explanation();
                finalExpl.addDetail(innerExplaination);
                float rawScore = innerExplaination.getValue();
                long timeVal = termList.getPrimitiveValue(orderArray.get(doc));
                float timeScore = this.computeTimeFactor(timeVal);
                float finalScore = RecencyBoostScorerBuilder.combineScores(timeScore, rawScore);
                finalExpl.setValue(finalScore);
                finalExpl.setDescription("final score = (time score: " + timeScore + ") * (raw score: " + rawScore + "), timeVal: " + timeVal);
                return finalExpl;
            }
            throw new IllegalStateException("underlying facet data must be of type FacetDataCache<Long>");
        }
        throw new IllegalStateException("reader not instance of " + BoboSegmentReader.class);
    }

    @Override
    public Scorer createScorer(final Scorer innerScorer, AtomicReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
        if (reader instanceof BoboSegmentReader) {
            BoboSegmentReader boboReader = (BoboSegmentReader)reader;
            Object dataObj = boboReader.getFacetData(this._timeFacetName);
            if (dataObj instanceof FacetDataCache) {
                FacetDataCache facetDataCache = (FacetDataCache)boboReader.getFacetData(this._timeFacetName);
                final BigSegmentedArray orderArray = facetDataCache.orderArray;
                final TermLongList termList = (TermLongList)facetDataCache.valArray;
                return new Scorer(innerScorer.getWeight()){

                    public float score() throws IOException {
                        float rawScore = innerScorer.score();
                        long timeVal = (Long)termList.getRawValue(orderArray.get(innerScorer.docID()));
                        float timeScore = RecencyBoostScorerBuilder.this.computeTimeFactor(timeVal);
                        return RecencyBoostScorerBuilder.combineScores(timeScore, rawScore);
                    }

                    public int advance(int target) throws IOException {
                        return innerScorer.advance(target);
                    }

                    public int docID() {
                        return innerScorer.docID();
                    }

                    public int nextDoc() throws IOException {
                        return innerScorer.nextDoc();
                    }

                    public int freq() throws IOException {
                        return 0;
                    }

                    public long cost() {
                        return 0L;
                    }
                };
            }
            throw new IllegalStateException("underlying facet data must be of type FacetDataCache<Long>");
        }
        throw new IllegalStateException("reader not instance of " + BoboSegmentReader.class);
    }

    protected float computeTimeFactor(long timeVal) {
        long xVal = this._now - timeVal;
        if (xVal > this._cutoffInMillis) {
            return this._min;
        }
        float xValFloat = xVal;
        return this._A * xValFloat * xValFloat + this._max;
    }

    private static float combineScores(float timeScore, float rawScore) {
        return timeScore * rawScore;
    }
}

