/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.ShortFacetIterator;
import com.browseengine.bobo.facets.data.TermShortList;
import com.browseengine.bobo.util.BigSegmentedArray;
import java.util.NoSuchElementException;

public class DefaultShortFacetIterator
extends ShortFacetIterator {
    public TermShortList _valList;
    private BigSegmentedArray _count;
    private int _countlength;
    private int _countLengthMinusOne;
    private int _index;

    public DefaultShortFacetIterator(TermShortList valList, BigSegmentedArray countarray, int countlength, boolean zeroBased) {
        this._valList = valList;
        this._countlength = countlength;
        this._count = countarray;
        this._countLengthMinusOne = this._countlength - 1;
        this._index = -1;
        if (!zeroBased) {
            ++this._index;
        }
        this.facet = Short.MIN_VALUE;
        this.count = 0;
    }

    public String getFacet() {
        if (this.facet == Short.MIN_VALUE) {
            return null;
        }
        return this._valList.format(this.facet);
    }

    @Override
    public String format(short val) {
        return this._valList.format(val);
    }

    @Override
    public String format(Object val) {
        return this._valList.format(val);
    }

    public int getFacetCount() {
        return this.count;
    }

    @Override
    public boolean hasNext() {
        return this._index < this._countLengthMinusOne;
    }

    @Override
    public String next() {
        if (this._index >= 0 && this._index >= this._countLengthMinusOne) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        ++this._index;
        this.facet = this._valList.getPrimitiveValue(this._index);
        this.count = this._count.get(this._index);
        return this._valList.get(this._index);
    }

    @Override
    public short nextShort() {
        if (this._index >= this._countLengthMinusOne) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        ++this._index;
        this.facet = this._valList.getPrimitiveValue(this._index);
        this.count = this._count.get(this._index);
        return this.facet;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for Facet Iterators");
    }

    public String next(int minHits) {
        while (++this._index < this._countlength) {
            if (this._count.get(this._index) < minHits) continue;
            this.facet = this._valList.getPrimitiveValue(this._index);
            this.count = this._count.get(this._index);
            return this._valList.format(this.facet);
        }
        this.facet = Short.MIN_VALUE;
        this.count = 0;
        return null;
    }

    @Override
    public short nextShort(int minHits) {
        while (++this._index < this._countlength) {
            if (this._count.get(this._index) < minHits) continue;
            this.facet = this._valList.getPrimitiveValue(this._index);
            this.count = this._count.get(this._index);
            return this.facet;
        }
        this.facet = Short.MIN_VALUE;
        this.count = 0;
        return this.facet;
    }
}

