/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public class FacetFilter
extends RandomAccessFilter {
    private final FacetHandler<FacetDataCache<?>> _facetHandler;
    protected final String _value;

    public FacetFilter(FacetHandler<FacetDataCache<?>> facetHandler, String value) {
        this._facetHandler = facetHandler;
        this._value = value;
    }

    @Override
    public double getFacetSelectivity(BoboSegmentReader reader) {
        double selectivity = 0.0;
        FacetDataCache<?> dataCache = this._facetHandler.getFacetData(reader);
        int idx = dataCache.valArray.indexOf(this._value);
        if (idx < 0) {
            return 0.0;
        }
        int freq = dataCache.freqs[idx];
        int total = reader.maxDoc();
        selectivity = (double)freq / (double)total;
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboSegmentReader reader) throws IOException {
        FacetDataCache<?> dataCache = this._facetHandler.getFacetData(reader);
        int index = dataCache.valArray.indexOf(this._value);
        if (index < 0) {
            return EmptyDocIdSet.getInstance();
        }
        return new FacetDataRandomAccessDocIdSet(dataCache, index);
    }

    public static class FacetDataRandomAccessDocIdSet
    extends RandomAccessDocIdSet {
        private final FacetDataCache<?> _dataCache;
        private final BigSegmentedArray _orderArray;
        private final int _index;

        FacetDataRandomAccessDocIdSet(FacetDataCache<?> dataCache, int index) {
            this._dataCache = dataCache;
            this._orderArray = this._dataCache.orderArray;
            this._index = index;
        }

        @Override
        public boolean get(int docId) {
            return this._orderArray.get(docId) == this._index;
        }

        public DocIdSetIterator iterator() throws IOException {
            return new FacetDocIdSetIterator(this._dataCache, this._index);
        }
    }

    public static class FacetDocIdSetIterator
    extends DocIdSetIterator {
        protected int _doc;
        protected final int _index;
        protected final int _maxID;
        protected final BigSegmentedArray _orderArray;

        public FacetDocIdSetIterator(FacetDataCache<?> dataCache, int index) {
            this._index = index;
            this._doc = Math.max(-1, dataCache.minIDs[this._index] - 1);
            this._maxID = dataCache.maxIDs[this._index];
            this._orderArray = dataCache.orderArray;
        }

        public final int docID() {
            return this._doc;
        }

        public int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this._orderArray.findValue(this._index, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        public int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this._orderArray.findValue(this._index, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }

        public long cost() {
            return 0L;
        }
    }
}

