/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.attribute;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.attribute.AttributesFacetCountCollector;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.range.MultiRangeFacetHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.index.Term;

public class AttributesFacetHandler
extends MultiRangeFacetHandler {
    public static final char DEFAULT_SEPARATOR = '=';
    private char separator;
    private int numFacetsPerKey = 7;
    public static final String SEPARATOR_PROP_NAME = "separator";
    public static final String MAX_FACETS_PER_KEY_PROP_NAME = "maxFacetsPerKey";

    public AttributesFacetHandler(String name, String indexFieldName, TermListFactory<?> termListFactory, Term sizePayloadTerm, Map<String, String> facetProps) {
        super(name, indexFieldName, sizePayloadTerm, termListFactory, Collections.<String>emptyList());
        this.separator = facetProps.containsKey(SEPARATOR_PROP_NAME) ? this.narrow(facetProps.get(SEPARATOR_PROP_NAME)).charAt(0) : (char)61;
        if (facetProps.containsKey(MAX_FACETS_PER_KEY_PROP_NAME)) {
            this.numFacetsPerKey = Integer.parseInt(this.narrow(facetProps.get(MAX_FACETS_PER_KEY_PROP_NAME)));
        }
    }

    private String narrow(String string) {
        return string.replaceAll("\\[", "").replaceAll("\\]", "");
    }

    public char getSeparator(BrowseSelection browseSelection) {
        if (browseSelection == null || !browseSelection.getSelectionProperties().containsKey(SEPARATOR_PROP_NAME)) {
            return this.separator;
        }
        return browseSelection.getSelectionProperties().get(SEPARATOR_PROP_NAME).toString().charAt(0);
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties prop) throws IOException {
        return super.buildRandomAccessFilter(AttributesFacetHandler.convertToRangeString(value, this.separator), prop);
    }

    public static String convertToRangeString(String key, char separator) {
        if (key.startsWith("[") && key.contains(" TO ")) {
            return key;
        }
        return "[" + key + separator + " TO " + key + (char)(separator + '\u0001') + ")";
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        String[] ranges = new String[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            ranges[i] = AttributesFacetHandler.convertToRangeString(vals[i], this.separator);
        }
        return super.buildRandomAccessOrFilter(ranges, prop, isNot);
    }

    public int getFacetsPerKey(BrowseSelection browseSelection) {
        if (browseSelection == null || !browseSelection.getSelectionProperties().containsKey(MAX_FACETS_PER_KEY_PROP_NAME)) {
            return this.numFacetsPerKey;
        }
        return Integer.valueOf(browseSelection.getSelectionProperties().get(MAX_FACETS_PER_KEY_PROP_NAME).toString());
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection browseSelection, final FacetSpec ospec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboSegmentReader reader, int docBase) {
                int facetsPerKey = AttributesFacetHandler.this.getFacetsPerKey(browseSelection);
                if (ospec.getProperties() != null && ospec.getProperties().containsKey(AttributesFacetHandler.MAX_FACETS_PER_KEY_PROP_NAME)) {
                    facetsPerKey = Integer.parseInt(ospec.getProperties().get(AttributesFacetHandler.MAX_FACETS_PER_KEY_PROP_NAME));
                }
                MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)reader.getFacetData(AttributesFacetHandler.this._name);
                return new AttributesFacetCountCollector(AttributesFacetHandler.this, AttributesFacetHandler.this._name, dataCache, docBase, browseSelection, ospec, facetsPerKey, AttributesFacetHandler.this.getSeparator(browseSelection));
            }
        };
    }
}

