/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.attribute;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.attribute.AttributesFacetHandler;
import com.browseengine.bobo.facets.attribute.AttributesFacetIterator;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.impl.DefaultFacetCountCollector;
import com.browseengine.bobo.util.BigIntArray;
import com.browseengine.bobo.util.BigNestedIntArray;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class AttributesFacetCountCollector
extends DefaultFacetCountCollector {
    public final BigNestedIntArray _array;
    private List<BrowseFacet> cachedFacets;
    private final int numFacetsPerKey;
    private final char separator;
    private final MultiValueFacetDataCache<?> dataCache;
    private String[] values;

    public AttributesFacetCountCollector(AttributesFacetHandler attributesFacetHandler, String name, MultiValueFacetDataCache dataCache, int docBase, BrowseSelection browseSelection, FacetSpec ospec, int numFacetsPerKey, char separator) {
        super(name, dataCache, docBase, browseSelection, ospec);
        this.dataCache = dataCache;
        this.numFacetsPerKey = numFacetsPerKey;
        this.separator = separator;
        this._array = dataCache._nestedArray;
        if (browseSelection != null) {
            this.values = browseSelection.getValues();
        }
    }

    @Override
    public final void collect(int docid) {
        this.dataCache._nestedArray.countNoReturn(docid, this._count);
    }

    @Override
    public final void collectAll() {
        this._count = BigIntArray.fromArray(this._dataCache.freqs);
    }

    @Override
    public List<BrowseFacet> getFacets() {
        if (this.cachedFacets == null) {
            int max = this._ospec.getMaxCount();
            this._ospec.setMaxCount(max * 10);
            List<BrowseFacet> facets = super.getFacets();
            this._ospec.setMaxCount(max);
            this.filterByKeys(facets, this.separator, this.numFacetsPerKey, this.values);
            this.cachedFacets = facets;
        }
        return this.cachedFacets;
    }

    private void filterByKeys(List<BrowseFacet> facets, char separator, int numFacetsPerKey, String[] values) {
        HashMap<String, AtomicInteger> keyOccurences = new HashMap<String, AtomicInteger>();
        Iterator<BrowseFacet> iterator = facets.iterator();
        String separatorString = String.valueOf(separator);
        while (iterator.hasNext()) {
            int count;
            String key;
            AtomicInteger numOfKeys;
            BrowseFacet facet = iterator.next();
            String value = facet.getValue();
            if (!value.contains(separatorString)) {
                iterator.remove();
                continue;
            }
            if (values != null && values.length > 0) {
                boolean belongsToKeys = false;
                for (String val : values) {
                    if (!value.startsWith(val)) continue;
                    belongsToKeys = true;
                    break;
                }
                if (!belongsToKeys) {
                    iterator.remove();
                    continue;
                }
            }
            if ((numOfKeys = (AtomicInteger)keyOccurences.get(key = value.substring(0, value.indexOf(separatorString)))) == null) {
                numOfKeys = new AtomicInteger(0);
                keyOccurences.put(key, numOfKeys);
            }
            if ((count = numOfKeys.incrementAndGet()) <= numFacetsPerKey) continue;
            iterator.remove();
        }
    }

    @Override
    public FacetIterator iterator() {
        return new AttributesFacetIterator(this.getFacets());
    }
}

