/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import com.browseengine.bobo.docidset.ImmutableDocSet;
import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class NotDocIdSet
extends ImmutableDocSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DocIdSet innerSet = null;
    private int max = -1;

    public NotDocIdSet(DocIdSet docSet, int maxVal) {
        this.innerSet = docSet;
        this.max = maxVal;
    }

    public DocIdSetIterator iterator() throws IOException {
        return new NotDocIdSetIterator();
    }

    @Override
    public int findWithIndex(int val) throws IOException {
        NotDocIdSetIterator finder = new NotDocIdSetIterator();
        int cursor = -1;
        try {
            int docid;
            while ((docid = finder.nextDoc()) != Integer.MAX_VALUE) {
                if (docid > val) {
                    return -1;
                }
                if (docid == val) {
                    return ++cursor;
                }
                ++cursor;
            }
        }
        catch (IOException e) {
            return -1;
        }
        return -1;
    }

    class NotDocIdSetIterator
    extends DocIdSetIterator {
        int lastReturn = -1;
        private DocIdSetIterator it1 = null;
        private int innerDocid = -1;

        NotDocIdSetIterator() throws IOException {
            this.initialize();
        }

        private void initialize() throws IOException {
            this.it1 = NotDocIdSet.this.innerSet.iterator();
            try {
                this.innerDocid = this.it1.nextDoc();
                if (this.innerDocid == Integer.MAX_VALUE) {
                    this.it1 = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public int docID() {
            return this.lastReturn;
        }

        public int nextDoc() throws IOException {
            return this.advance(0);
        }

        public int advance(int target) throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (target <= this.lastReturn) {
                target = this.lastReturn + 1;
            }
            if (target >= NotDocIdSet.this.max) {
                this.lastReturn = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.it1 != null && this.innerDocid < target && (this.innerDocid = this.it1.advance(target)) == Integer.MAX_VALUE) {
                this.it1 = null;
            }
            while (this.it1 != null && this.innerDocid == target) {
                if (++target >= NotDocIdSet.this.max) {
                    this.lastReturn = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.innerDocid = this.it1.advance(target);
                if (this.innerDocid != Integer.MAX_VALUE) continue;
                this.it1 = null;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        public long cost() {
            return 0L;
        }
    }
}

