/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import com.browseengine.bobo.docidset.DocSet;
import com.browseengine.bobo.docidset.IntArray;
import com.browseengine.bobo.docidset.StatefulDSIterator;
import java.io.IOException;
import java.io.Serializable;

public class IntArrayDocIdSet
extends DocSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IntArray array = null;
    private int pos = -1;

    public IntArrayDocIdSet(int length) {
        this.array = new IntArray(length);
    }

    public IntArrayDocIdSet() {
        this.array = new IntArray();
    }

    @Override
    public void addDoc(int docid) {
        ++this.pos;
        this.array.add(docid);
    }

    public final boolean isCacheable() {
        return true;
    }

    protected int binarySearchForNearest(int val, int begin, int end) {
        int mid = (begin + end) / 2;
        int midval = this.array.get(mid);
        if (mid == end) {
            return midval >= val ? mid : -1;
        }
        if (midval < val) {
            if (this.array.get(mid + 1) >= val) {
                return mid + 1;
            }
            return this.binarySearchForNearest(val, mid + 1, end);
        }
        if (midval == val) {
            return mid;
        }
        return this.binarySearchForNearest(val, begin, mid);
    }

    public IntArrayDocIdSetIterator iterator() {
        return new IntArrayDocIdSetIterator();
    }

    @Override
    public int size() {
        return this.pos + 1;
    }

    @Override
    public int findWithIndex(int val) {
        IntArrayDocIdSetIterator dcit = new IntArrayDocIdSetIterator();
        try {
            int docid = dcit.advance(val);
            if (docid == val) {
                return dcit.getCursor();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1;
    }

    @Override
    public long sizeInBytes() {
        return this.array.length() * 4 + 64;
    }

    @Override
    public void optimize() {
        this.array.seal();
    }

    class IntArrayDocIdSetIterator
    extends StatefulDSIterator {
        int lastReturn = -1;
        int cursor = -1;

        public IntArrayDocIdSetIterator() {
            if (IntArrayDocIdSet.this.pos == -1) {
                this.lastReturn = Integer.MAX_VALUE;
            }
        }

        public int docID() {
            return this.lastReturn;
        }

        public int nextDoc() throws IOException {
            if (this.cursor < IntArrayDocIdSet.this.pos) {
                this.lastReturn = IntArrayDocIdSet.this.array.get(++this.cursor);
                return this.lastReturn;
            }
            this.lastReturn = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            int end;
            int index;
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (target <= this.lastReturn) {
                target = this.lastReturn + 1;
            }
            if ((index = IntArrayDocIdSet.this.binarySearchForNearest(target, this.cursor + 1, end = Math.min(this.cursor + (target - this.lastReturn), IntArrayDocIdSet.this.pos))) == -1) {
                this.cursor = IntArrayDocIdSet.this.pos;
                this.lastReturn = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.cursor = index;
            this.lastReturn = IntArrayDocIdSet.this.array.get(this.cursor);
            return this.lastReturn;
        }

        @Override
        public int getCursor() {
            return this.cursor;
        }

        public long cost() {
            return 0L;
        }
    }
}

