/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.facets.impl.PathFacetIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MappedFacetAccessible
implements FacetAccessible,
Serializable {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, BrowseFacet> _facetMap = new HashMap();
    private final BrowseFacet[] _facets;

    public MappedFacetAccessible(BrowseFacet[] facets) {
        for (BrowseFacet facet : facets) {
            this._facetMap.put(facet.getValue(), facet);
        }
        this._facets = facets;
    }

    @Override
    public BrowseFacet getFacet(String value) {
        return this._facetMap.get(value);
    }

    @Override
    public int getFacetHitsCount(Object value) {
        BrowseFacet facet = this._facetMap.get(value);
        if (facet != null) {
            return facet.getFacetValueHitCount();
        }
        return 0;
    }

    @Override
    public List<BrowseFacet> getFacets() {
        return Arrays.asList(this._facets);
    }

    @Override
    public void close() {
    }

    @Override
    public FacetIterator iterator() {
        return new PathFacetIterator(Arrays.asList(this._facets));
    }
}

