/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.RuntimeFacetHandler;
import com.browseengine.bobo.facets.RuntimeFacetHandlerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFieldVisitor;

public class BoboSegmentReader
extends FilterAtomicReader {
    private static Logger logger = Logger.getLogger(BoboSegmentReader.class);
    protected Map<String, FacetHandler<?>> _facetHandlerMap;
    protected Collection<FacetHandler<?>> _facetHandlers;
    protected Collection<RuntimeFacetHandlerFactory<?, ?>> _runtimeFacetHandlerFactories;
    protected Map<String, RuntimeFacetHandlerFactory<?, ?>> _runtimeFacetHandlerFactoryMap;
    protected WorkArea _workArea;
    private final Map<String, Object> _facetDataMap = new HashMap<String, Object>();
    private final ThreadLocal<Map<String, Object>> _runtimeFacetDataMap = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private final ThreadLocal<Map<String, RuntimeFacetHandler<?>>> _runtimeFacetHandlerMap = new ThreadLocal<Map<String, RuntimeFacetHandler<?>>>(){

        @Override
        protected Map<String, RuntimeFacetHandler<?>> initialValue() {
            return new HashMap();
        }
    };

    public static BoboSegmentReader getInstance(AtomicReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories) throws IOException {
        return BoboSegmentReader.getInstance(reader, facetHandlers, facetHandlerFactories, new WorkArea());
    }

    private static BoboSegmentReader getInstance(AtomicReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories, WorkArea workArea) throws IOException {
        BoboSegmentReader boboReader = new BoboSegmentReader(reader, facetHandlers, facetHandlerFactories, workArea);
        boboReader.facetInit();
        return boboReader;
    }

    public Object getFacetData(String name) {
        return this._facetDataMap.get(name);
    }

    public Object putFacetData(String name, Object data) {
        return this._facetDataMap.put(name, data);
    }

    public Object getRuntimeFacetData(String name) {
        Map<String, Object> map = this._runtimeFacetDataMap.get();
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public Object putRuntimeFacetData(String name, Object data) {
        Map<String, Object> map = this._runtimeFacetDataMap.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            this._runtimeFacetDataMap.set(map);
        }
        return map.put(name, data);
    }

    public void clearRuntimeFacetData() {
        this._runtimeFacetDataMap.set(null);
    }

    public RuntimeFacetHandler<?> getRuntimeFacetHandler(String name) {
        Map<String, RuntimeFacetHandler<?>> map = this._runtimeFacetHandlerMap.get();
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public void putRuntimeFacetHandler(String name, RuntimeFacetHandler<?> data) {
        Map<String, RuntimeFacetHandler<?>> map = this._runtimeFacetHandlerMap.get();
        if (map == null) {
            map = new HashMap();
            this._runtimeFacetHandlerMap.set(map);
        }
        map.put(name, data);
    }

    public void clearRuntimeFacetHandler() {
        this._runtimeFacetHandlerMap.set(null);
    }

    protected void doClose() throws IOException {
    }

    private void loadFacetHandler(String name, Set<String> loaded, Set<String> visited, WorkArea workArea) throws IOException {
        FacetHandler<?> facetHandler = this._facetHandlerMap.get(name);
        if (facetHandler != null && !loaded.contains(name)) {
            visited.add(name);
            Set<String> dependsOn = facetHandler.getDependsOn();
            if (dependsOn.size() > 0) {
                for (String f : dependsOn) {
                    if (name.equals(f)) continue;
                    if (!loaded.contains(f)) {
                        if (visited.contains(f)) {
                            throw new IOException("Facet handler dependency cycle detected, facet handler: " + name + " not loaded");
                        }
                        this.loadFacetHandler(f, loaded, visited, workArea);
                    }
                    if (!loaded.contains(f)) {
                        throw new IOException("unable to load facet handler: " + f);
                    }
                    facetHandler.putDependedFacetHandler(this._facetHandlerMap.get(f));
                }
            }
            long start = System.currentTimeMillis();
            facetHandler.loadFacetData(this, workArea);
            long end = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("facetHandler loaded: ").append(name).append(", took: ").append(end - start).append(" ms");
                logger.debug((Object)buf.toString());
            }
            loaded.add(name);
        }
    }

    private void loadFacetHandlers(WorkArea workArea) throws IOException {
        HashSet<String> loaded = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String name : this._facetHandlerMap.keySet()) {
            this.loadFacetHandler(name, loaded, visited, workArea);
        }
    }

    protected void initialize(Collection<FacetHandler<?>> facetHandlers) throws IOException {
        this._facetHandlers = facetHandlers;
        this._facetHandlerMap = new HashMap();
        for (FacetHandler<?> facetHandler : facetHandlers) {
            this._facetHandlerMap.put(facetHandler.getName(), facetHandler);
        }
    }

    protected BoboSegmentReader(AtomicReader reader, Collection<FacetHandler<?>> facetHandlers, Collection<RuntimeFacetHandlerFactory<?, ?>> facetHandlerFactories, WorkArea workArea) throws IOException {
        super(reader);
        this._runtimeFacetHandlerFactories = facetHandlerFactories;
        this._runtimeFacetHandlerFactoryMap = new HashMap();
        if (this._runtimeFacetHandlerFactories != null) {
            for (RuntimeFacetHandlerFactory<?, ?> factory : this._runtimeFacetHandlerFactories) {
                this._runtimeFacetHandlerFactoryMap.put(factory.getName(), factory);
            }
        }
        this._facetHandlers = facetHandlers;
        this._workArea = workArea;
    }

    protected void facetInit() throws IOException {
        this.initialize(this._facetHandlers);
        this.loadFacetHandlers(this._workArea);
    }

    public Set<String> getFacetNames() {
        return this._facetHandlerMap.keySet();
    }

    public FacetHandler<?> getFacetHandler(String fieldname) {
        FacetHandler<?> f = this._facetHandlerMap.get(fieldname);
        if (f == null) {
            f = this.getRuntimeFacetHandler(fieldname);
        }
        return f;
    }

    public Map<String, FacetHandler<?>> getFacetHandlerMap() {
        return this._facetHandlerMap;
    }

    public Map<String, RuntimeFacetHandlerFactory<?, ?>> getRuntimeFacetHandlerFactoryMap() {
        return this._runtimeFacetHandlerFactoryMap;
    }

    public Map<String, RuntimeFacetHandler<?>> getRuntimeFacetHandlerMap() {
        return this._runtimeFacetHandlerMap.get();
    }

    public Map<String, Object> getRuntimeFacetDataMap() {
        return this._runtimeFacetDataMap.get();
    }

    public void setRuntimeFacetHandlerMap(Map<String, RuntimeFacetHandler<?>> map) {
        this._runtimeFacetHandlerMap.set(map);
    }

    public void setRuntimeFacetDataMap(Map<String, Object> map) {
        this._runtimeFacetDataMap.set(map);
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        super.document(docID, visitor);
        if (!(visitor instanceof DocumentStoredFieldVisitor)) {
            return;
        }
        Document doc = ((DocumentStoredFieldVisitor)visitor).getDocument();
        Collection<FacetHandler<?>> facetHandlers = this._facetHandlerMap.values();
        for (FacetHandler<?> facetHandler : facetHandlers) {
            String[] vals = facetHandler.getFieldValues(this, docID);
            if (vals == null) continue;
            String[] values = doc.getValues(facetHandler.getName());
            HashSet<String> storedVals = new HashSet<String>(Arrays.asList(values));
            for (String val : vals) {
                storedVals.add(val);
            }
            doc.removeField(facetHandler.getName());
            for (String val : storedVals) {
                doc.add((IndexableField)new StringField(facetHandler.getName(), val, Field.Store.NO));
            }
        }
    }

    public String[] getStoredFieldValue(int docid, String fieldname) throws IOException {
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor(new String[]{fieldname});
        super.document(docid, (StoredFieldVisitor)visitor);
        Document doc = visitor.getDocument();
        return doc.getValues(fieldname);
    }

    private BoboSegmentReader(AtomicReader in) {
        super(in);
    }

    public BoboSegmentReader copy(AtomicReader in) {
        BoboSegmentReader copy = new BoboSegmentReader(in);
        copy._facetHandlerMap = this._facetHandlerMap;
        copy._facetHandlers = this._facetHandlers;
        copy._runtimeFacetHandlerFactories = this._runtimeFacetHandlerFactories;
        copy._runtimeFacetHandlerFactoryMap = this._runtimeFacetHandlerFactoryMap;
        copy._workArea = this._workArea;
        copy._facetDataMap.putAll(this._facetDataMap);
        return copy;
    }

    public AtomicReader getInnerReader() {
        return this.in;
    }

    public static class WorkArea {
        HashMap<Class<?>, Object> map = new HashMap();

        public <T> T get(Class<T> cls) {
            Object obj = this.map.get(cls);
            return (T)obj;
        }

        public void put(Object obj) {
            this.map.put(obj.getClass(), obj);
        }

        public void clear() {
            this.map.clear();
        }

        public String toString() {
            return this.map.toString();
        }
    }
}

