/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.facets.FacetHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;

public class BoboMultiReader
extends FilterDirectoryReader {
    protected List<BoboSegmentReader> _subReaders = this.getSequentialSubReaders();

    public static BoboMultiReader getInstance(DirectoryReader reader) throws IOException {
        return BoboMultiReader.getInstance(reader, null);
    }

    public static BoboMultiReader getInstance(DirectoryReader reader, Collection<FacetHandler<?>> facetHandlers) throws IOException {
        BoboMultiReader boboReader = new BoboMultiReader(reader, facetHandlers);
        boboReader.facetInit();
        return boboReader;
    }

    protected void doClose() throws IOException {
    }

    protected BoboMultiReader(DirectoryReader reader, Collection<FacetHandler<?>> facetHandlers) throws IOException {
        super(reader, (FilterDirectoryReader.SubReaderWrapper)new BoboSubReaderWrapper(facetHandlers));
    }

    protected void facetInit() throws IOException {
        for (BoboSegmentReader r : this._subReaders) {
            r.facetInit();
        }
    }

    public List<BoboSegmentReader> getSubReaders() {
        return this._subReaders;
    }

    public final int subReaderBase(int readerIndex) {
        return this.readerBase(readerIndex);
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
        return in;
    }

    public static class BoboSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final BoboSegmentReader.WorkArea workArea = new BoboSegmentReader.WorkArea();
        private Collection<FacetHandler<?>> _facetHandlers = null;

        public BoboSubReaderWrapper(Collection<FacetHandler<?>> facetHandlers) {
            this._facetHandlers = facetHandlers;
        }

        public AtomicReader wrap(AtomicReader reader) {
            try {
                return new BoboSegmentReader(reader, this._facetHandlers, null, this.workArea);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

