/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.DoubleFacetIterator;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.api.FloatFacetIterator;
import com.browseengine.bobo.api.IntFacetIterator;
import com.browseengine.bobo.api.LongFacetIterator;
import com.browseengine.bobo.api.ShortFacetIterator;
import com.browseengine.bobo.facets.impl.CombinedDoubleFacetIterator;
import com.browseengine.bobo.facets.impl.CombinedFacetIterator;
import com.browseengine.bobo.facets.impl.CombinedFloatFacetIterator;
import com.browseengine.bobo.facets.impl.CombinedIntFacetIterator;
import com.browseengine.bobo.facets.impl.CombinedLongFacetIterator;
import com.browseengine.bobo.facets.impl.CombinedShortFacetIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.util.PriorityQueue;

public class CombinedFacetAccessible
implements FacetAccessible {
    private static final Logger log = Logger.getLogger(CombinedFacetAccessible.class);
    private final List<FacetAccessible> _list;
    private final FacetSpec _fspec;
    private boolean _closed;

    public CombinedFacetAccessible(FacetSpec fspec, List<FacetAccessible> list) {
        this._list = list;
        this._fspec = fspec;
    }

    public String toString() {
        return "_list:" + this._list + " _fspec:" + this._fspec;
    }

    @Override
    public BrowseFacet getFacet(String value) {
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector was already closed");
        }
        int sum = -1;
        String foundValue = null;
        if (this._list != null) {
            for (FacetAccessible facetAccessor : this._list) {
                BrowseFacet facet = facetAccessor.getFacet(value);
                if (facet == null) continue;
                foundValue = facet.getValue();
                if (sum == -1) {
                    sum = facet.getHitCount();
                    continue;
                }
                sum += facet.getHitCount();
            }
        }
        if (sum == -1) {
            return null;
        }
        return new BrowseFacet(foundValue, sum);
    }

    public int getCappedFacetCount(Object value, int cap) {
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector was already closed");
        }
        int sum = 0;
        if (this._list != null) {
            for (FacetAccessible facetAccessor : this._list) {
                sum = facetAccessor instanceof CombinedFacetAccessible ? (sum += ((CombinedFacetAccessible)facetAccessor).getCappedFacetCount(value, cap - sum)) : (sum += facetAccessor.getFacetHitsCount(value));
                if (sum < cap) continue;
                return cap;
            }
        }
        return sum;
    }

    @Override
    public int getFacetHitsCount(Object value) {
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector was already closed");
        }
        int sum = 0;
        if (this._list != null) {
            for (FacetAccessible facetAccessor : this._list) {
                sum += facetAccessor.getFacetHitsCount(value);
            }
        }
        return sum;
    }

    @Override
    public List<BrowseFacet> getFacets() {
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector was already closed");
        }
        int maxCnt = this._fspec.getMaxCount();
        if (maxCnt <= 0) {
            maxCnt = Integer.MAX_VALUE;
        }
        int minHits = this._fspec.getMinHitCount();
        LinkedList<BrowseFacet> list = new LinkedList<BrowseFacet>();
        int cnt = 0;
        Comparable facet = null;
        FacetIterator iter = this.iterator();
        if (FacetSpec.FacetSortSpec.OrderValueAsc.equals((Object)this._fspec.getOrderBy())) {
            while ((facet = iter.next(minHits)) != null) {
                list.add(new BrowseFacet(String.valueOf(facet), iter.count));
                if (++cnt < maxCnt) continue;
                break;
            }
        } else if (FacetSpec.FacetSortSpec.OrderHitsDesc.equals((Object)this._fspec.getOrderBy())) {
            Comparator<BrowseFacet> comparator = new Comparator<BrowseFacet>(){

                @Override
                public int compare(BrowseFacet f1, BrowseFacet f2) {
                    int val = f2.getHitCount() - f1.getHitCount();
                    if (val == 0) {
                        val = f1.getValue().compareTo(f2.getValue());
                    }
                    return val;
                }
            };
            if (maxCnt != Integer.MAX_VALUE) {
                int qsize;
                PriorityQueue queue = this.createPQ(maxCnt, comparator);
                for (qsize = 0; qsize < maxCnt && (facet = iter.next(minHits)) != null; ++qsize) {
                    queue.add((Object)new BrowseFacet(String.valueOf(facet), iter.count));
                }
                if (facet != null) {
                    BrowseFacet rootFacet = (BrowseFacet)queue.top();
                    minHits = rootFacet.getHitCount() + 1;
                    while ((facet = iter.next(minHits)) != null) {
                        rootFacet.setValue(String.valueOf(facet));
                        rootFacet.setHitCount(iter.count);
                        rootFacet = (BrowseFacet)queue.updateTop();
                        minHits = rootFacet.getHitCount() + 1;
                    }
                }
                while (qsize-- > 0) {
                    list.addFirst((BrowseFacet)queue.pop());
                }
            } else {
                while ((facet = iter.next(minHits)) != null) {
                    list.add(new BrowseFacet(String.valueOf(facet), iter.count));
                }
                Collections.sort(list, comparator);
            }
        } else {
            Comparator<BrowseFacet> comparator = this._fspec.getCustomComparatorFactory().newComparator();
            if (maxCnt != Integer.MAX_VALUE) {
                int qsize;
                PriorityQueue queue = this.createPQ(maxCnt, comparator);
                BrowseFacet browseFacet = new BrowseFacet();
                for (qsize = 0; qsize < maxCnt && (facet = iter.next(minHits)) != null; ++qsize) {
                    queue.add((Object)new BrowseFacet(String.valueOf(facet), iter.count));
                }
                if (facet != null) {
                    while ((facet = iter.next(minHits)) != null) {
                        browseFacet.setHitCount(iter.count);
                        browseFacet.setValue(String.valueOf(facet));
                        browseFacet = (BrowseFacet)queue.insertWithOverflow((Object)browseFacet);
                    }
                }
                while (qsize-- > 0) {
                    list.addFirst((BrowseFacet)queue.pop());
                }
            } else {
                while ((facet = iter.next(minHits)) != null) {
                    list.add(new BrowseFacet(String.valueOf(facet), iter.count));
                }
                Collections.sort(list, comparator);
            }
        }
        return list;
    }

    private PriorityQueue createPQ(final int max, final Comparator<BrowseFacet> comparator) {
        PriorityQueue queue = new PriorityQueue(){
            {
                this.initialize(max);
            }

            protected boolean lessThan(Object arg0, Object arg1) {
                BrowseFacet o1 = (BrowseFacet)arg0;
                BrowseFacet o2 = (BrowseFacet)arg1;
                return comparator.compare(o1, o2) > 0;
            }
        };
        return queue;
    }

    @Override
    public void close() {
        if (this._closed) {
            log.warn((Object)"This instance of count collector was already closed. This operation is no-op.");
            return;
        }
        this._closed = true;
        if (this._list != null) {
            for (FacetAccessible fa : this._list) {
                fa.close();
            }
            this._list.clear();
        }
    }

    @Override
    public FacetIterator iterator() {
        ArrayList<IntFacetIterator> il;
        FacetIterator iter;
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector was already closed");
        }
        ArrayList<FacetIterator> iterList = new ArrayList<FacetIterator>(this._list.size());
        for (FacetAccessible facetAccessor : this._list) {
            iter = facetAccessor.iterator();
            if (iter == null) continue;
            iterList.add(iter);
        }
        if (iterList.get(0) instanceof IntFacetIterator) {
            il = new ArrayList<IntFacetIterator>();
            for (FacetAccessible facetAccessor : this._list) {
                iter = facetAccessor.iterator();
                if (iter == null) continue;
                il.add((IntFacetIterator)iter);
            }
            return new CombinedIntFacetIterator(il, this._fspec.getMinHitCount());
        }
        if (iterList.get(0) instanceof LongFacetIterator) {
            il = new ArrayList();
            for (FacetAccessible facetAccessor : this._list) {
                iter = facetAccessor.iterator();
                if (iter == null) continue;
                il.add((IntFacetIterator)((Object)((LongFacetIterator)iter)));
            }
            return new CombinedLongFacetIterator(il, this._fspec.getMinHitCount());
        }
        if (iterList.get(0) instanceof ShortFacetIterator) {
            il = new ArrayList();
            for (FacetAccessible facetAccessor : this._list) {
                iter = facetAccessor.iterator();
                if (iter == null) continue;
                il.add((IntFacetIterator)((Object)((ShortFacetIterator)iter)));
            }
            return new CombinedShortFacetIterator(il, this._fspec.getMinHitCount());
        }
        if (iterList.get(0) instanceof FloatFacetIterator) {
            il = new ArrayList();
            for (FacetAccessible facetAccessor : this._list) {
                iter = facetAccessor.iterator();
                if (iter == null) continue;
                il.add((IntFacetIterator)((Object)((FloatFacetIterator)iter)));
            }
            return new CombinedFloatFacetIterator(il, this._fspec.getMinHitCount());
        }
        if (iterList.get(0) instanceof DoubleFacetIterator) {
            il = new ArrayList();
            for (FacetAccessible facetAccessor : this._list) {
                iter = facetAccessor.iterator();
                if (iter == null) continue;
                il.add((IntFacetIterator)((Object)((DoubleFacetIterator)iter)));
            }
            return new CombinedDoubleFacetIterator(il, this._fspec.getMinHitCount());
        }
        return new CombinedFacetIterator(iterList);
    }
}

