/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.sort.DocIDPriorityQueue;
import com.browseengine.bobo.sort.SortCollector;
import com.browseengine.bobo.util.ListMerger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;

public class SortCollectorImpl
extends SortCollector {
    private static final Comparator<MyScoreDoc> MERGE_COMPATATOR = new Comparator<MyScoreDoc>(){

        @Override
        public int compare(MyScoreDoc o1, MyScoreDoc o2) {
            int v;
            Comparable s1 = o1.getValue();
            Comparable s2 = o2.getValue();
            int r = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : ((v = s1.compareTo(s2)) == 0 ? o1.doc + o1.queue.base - o2.doc - o2.queue.base : v));
            return r;
        }
    };
    private final LinkedList<DocIDPriorityQueue> _pqList;
    private final int _numHits;
    private int _totalHits;
    private ScoreDoc _bottom;
    private ScoreDoc _tmpScoreDoc;
    private boolean _queueFull;
    private DocComparator _currentComparator;
    private DocComparatorSource _compSource;
    private DocIDPriorityQueue _currentQueue;
    private BoboIndexReader _currentReader = null;
    private final boolean _doScoring;
    private Scorer _scorer;
    private final int _offset;
    private final int _count;
    private final Map<String, FacetHandler<?>> _facetHandlerMap;

    public SortCollectorImpl(DocComparatorSource compSource, SortField[] sortFields, Browsable boboBrowser, int offset, int count, boolean doScoring, boolean fetchStoredFields) {
        super(sortFields, fetchStoredFields);
        assert (offset >= 0 && count >= 0);
        this._facetHandlerMap = boboBrowser.getFacetHandlerMap();
        this._compSource = compSource;
        this._pqList = new LinkedList();
        this._numHits = offset + count;
        this._offset = offset;
        this._count = count;
        this._totalHits = 0;
        this._queueFull = false;
        this._doScoring = doScoring;
        this._tmpScoreDoc = new MyScoreDoc();
    }

    public boolean acceptsDocsOutOfOrder() {
        return this._collector == null ? true : this._collector.acceptsDocsOutOfOrder();
    }

    public void collect(int doc) throws IOException {
        float score;
        ++this._totalHits;
        float f = score = this._doScoring ? this._scorer.score() : 0.0f;
        if (this._queueFull) {
            this._tmpScoreDoc.doc = doc;
            this._tmpScoreDoc.score = score;
            if (this._currentComparator.compare(this._bottom, this._tmpScoreDoc) > 0) {
                ScoreDoc tmp = this._bottom;
                this._bottom = this._currentQueue.replace(this._tmpScoreDoc);
                this._tmpScoreDoc = tmp;
            }
        } else {
            this._bottom = this._currentQueue.add(new MyScoreDoc(doc, score, this._currentQueue, this._currentReader));
            boolean bl = this._queueFull = this._currentQueue.size >= this._numHits;
        }
        if (this._collector != null) {
            this._collector.collect(doc);
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        assert (reader instanceof BoboIndexReader);
        this._currentReader = (BoboIndexReader)reader;
        this._currentComparator = this._compSource.getComparator(reader, docBase);
        this._currentQueue = new DocIDPriorityQueue(this._currentComparator, this._numHits, docBase);
        MyScoreDoc myScoreDoc = (MyScoreDoc)this._tmpScoreDoc;
        myScoreDoc.queue = this._currentQueue;
        myScoreDoc.reader = this._currentReader;
        myScoreDoc.sortValue = null;
        this._pqList.add(this._currentQueue);
        this._queueFull = false;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this._scorer = scorer;
        this._currentComparator.setScorer(scorer);
    }

    @Override
    public int getTotalHits() {
        return this._totalHits;
    }

    @Override
    public BrowseHit[] topDocs() throws IOException {
        ArrayList iterList = new ArrayList(this._pqList.size());
        for (DocIDPriorityQueue pq : this._pqList) {
            int count = pq.size();
            MyScoreDoc[] resList = new MyScoreDoc[count];
            for (int i = count - 1; i >= 0; --i) {
                resList[i] = (MyScoreDoc)pq.pop();
            }
            iterList.add(Arrays.asList(resList).iterator());
        }
        ArrayList<MyScoreDoc> resList = ListMerger.mergeLists(this._offset, this._count, iterList, MERGE_COMPATATOR);
        return SortCollectorImpl.buildHits(resList.toArray(new MyScoreDoc[resList.size()]), this._sortFields, this._facetHandlerMap, this._fetchStoredFields);
    }

    protected static BrowseHit[] buildHits(MyScoreDoc[] scoreDocs, SortField[] sortFields, Map<String, FacetHandler<?>> facetHandlerMap, boolean fetchStoredFields) throws IOException {
        BrowseHit[] hits = new BrowseHit[scoreDocs.length];
        Collection<FacetHandler<?>> facetHandlers = facetHandlerMap.values();
        for (int i = scoreDocs.length - 1; i >= 0; --i) {
            MyScoreDoc fdoc = scoreDocs[i];
            BoboIndexReader reader = fdoc.reader;
            BrowseHit hit = new BrowseHit();
            if (fetchStoredFields) {
                hit.setStoredFields(reader.document(fdoc.doc));
            }
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            HashMap<String, Object[]> rawMap = new HashMap<String, Object[]>();
            for (FacetHandler<?> facetHandler : facetHandlers) {
                map.put(facetHandler.getName(), facetHandler.getFieldValues(reader, fdoc.doc));
                rawMap.put(facetHandler.getName(), facetHandler.getRawFieldValues(reader, fdoc.doc));
            }
            hit.setFieldValues(map);
            hit.setRawFieldValues(rawMap);
            hit.setDocid(fdoc.doc + fdoc.queue.base);
            hit.setScore(fdoc.score);
            hit.setComparable(fdoc.getValue());
            hits[i] = hit;
        }
        return hits;
    }

    static class MyScoreDoc
    extends ScoreDoc {
        private static final long serialVersionUID = 1L;
        DocIDPriorityQueue queue;
        BoboIndexReader reader;
        Comparable sortValue;

        public MyScoreDoc() {
            this(0, 0.0f, null, null);
        }

        public MyScoreDoc(int docid, float score, DocIDPriorityQueue queue, BoboIndexReader reader) {
            super(docid, score);
            this.queue = queue;
            this.reader = reader;
            this.sortValue = null;
        }

        Comparable getValue() {
            if (this.sortValue == null) {
                this.sortValue = this.queue.sortValue(this);
            }
            return this.sortValue;
        }
    }
}

