/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.filter.GeoFacetFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.GeoFacetCountCollector;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.util.BigFloatArray;
import com.browseengine.bobo.util.GeoMatchUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public class GeoFacetHandler
extends FacetHandler<GeoFacetData> {
    private static Logger logger = Logger.getLogger(GeoFacetHandler.class);
    private String _latFieldName;
    private String _lonFieldName;
    private boolean _miles;

    public GeoFacetHandler(String name, String latFieldName, String lonFieldName) {
        super(name);
        this._latFieldName = latFieldName;
        this._lonFieldName = lonFieldName;
        this._miles = true;
    }

    public GeoFacetHandler(String name, String latFieldName, String lonFieldName, boolean miles) {
        super(name);
        this._latFieldName = latFieldName;
        this._lonFieldName = lonFieldName;
        this._miles = miles;
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties selectionProperty) throws IOException {
        GeoFacetCountCollector.GeoRange range = GeoFacetCountCollector.parse(value);
        return new GeoFacetFilter(this, range.getLat(), range.getLon(), range.getRad(), this._miles);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        throw new UnsupportedOperationException("Doc comparator not yet supported for Geo Facets");
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec fspec) {
        return new FacetCountCollectorSource(){
            final List<String> ranges;
            {
                this.ranges = Arrays.asList(sel.getValues());
            }

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                GeoFacetData dataCache = (GeoFacetData)GeoFacetHandler.this.getFacetData(reader);
                return new GeoFacetCountCollector(GeoFacetHandler.this._name, dataCache, docBase, fspec, this.ranges, GeoFacetHandler.this._miles);
            }
        };
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        GeoFacetData dataCache = (GeoFacetData)this.getFacetData(reader);
        BigFloatArray xvals = dataCache.get_xValArray();
        BigFloatArray yvals = dataCache.get_yValArray();
        BigFloatArray zvals = dataCache.get_zValArray();
        float xvalue = xvals.get(id);
        float yvalue = yvals.get(id);
        float zvalue = zvals.get(id);
        float lat = GeoMatchUtil.getMatchLatDegreesFromXYZCoords(xvalue, yvalue, zvalue);
        float lon = GeoMatchUtil.getMatchLonDegreesFromXYZCoords(xvalue, yvalue, zvalue);
        String[] fieldValues = new String[]{String.valueOf(lat), String.valueOf(lon)};
        return fieldValues;
    }

    @Override
    public GeoFacetData load(BoboIndexReader reader) throws IOException {
        GeoFacetData dataCache = new GeoFacetData();
        dataCache.load(this._latFieldName, this._lonFieldName, reader);
        return dataCache;
    }

    public static class GeoFacetData {
        private BigFloatArray _xValArray;
        private BigFloatArray _yValArray;
        private BigFloatArray _zValArray;

        public GeoFacetData() {
            this._xValArray = null;
            this._yValArray = null;
            this._zValArray = null;
        }

        public GeoFacetData(BigFloatArray xvals, BigFloatArray yvals, BigFloatArray zvals) {
            this._xValArray = xvals;
            this._yValArray = yvals;
            this._zValArray = zvals;
        }

        public static BigFloatArray newInstance(int maxDoc) {
            BigFloatArray array = new BigFloatArray(maxDoc);
            array.ensureCapacity(maxDoc);
            return array;
        }

        public BigFloatArray get_xValArray() {
            return this._xValArray;
        }

        public void set_xValArray(BigFloatArray xValArray) {
            this._xValArray = xValArray;
        }

        public BigFloatArray get_yValArray() {
            return this._yValArray;
        }

        public void set_yValArray(BigFloatArray yValArray) {
            this._yValArray = yValArray;
        }

        public BigFloatArray get_zValArray() {
            return this._zValArray;
        }

        public void set_zValArray(BigFloatArray zValArray) {
            this._zValArray = zValArray;
        }

        public void load(String latFieldName, String lonFieldName, BoboIndexReader reader) throws IOException {
            Term term;
            if (reader == null) {
                throw new NullPointerException("reader object is null");
            }
            if (latFieldName == null) {
                throw new NullPointerException("latitude Field Name is null");
            }
            if (lonFieldName == null) {
                throw new NullPointerException("longitude Field Name is null");
            }
            int maxDoc = reader.maxDoc();
            BigFloatArray xVals = this._xValArray;
            BigFloatArray yVals = this._yValArray;
            BigFloatArray zVals = this._zValArray;
            if (xVals == null) {
                xVals = GeoFacetData.newInstance(maxDoc);
            } else {
                xVals.ensureCapacity(maxDoc);
            }
            if (yVals == null) {
                yVals = GeoFacetData.newInstance(maxDoc);
            } else {
                yVals.ensureCapacity(maxDoc);
            }
            if (zVals == null) {
                zVals = GeoFacetData.newInstance(maxDoc);
            } else {
                zVals.ensureCapacity(maxDoc);
            }
            this._xValArray = xVals;
            this._yValArray = yVals;
            this._zValArray = zVals;
            Term latTerm = new Term(latFieldName, "");
            TermDocs termDocs = reader.termDocs(latTerm);
            TermEnum termEnum = reader.terms(latTerm);
            int termCount = 1;
            String lonValue = null;
            int length = maxDoc + 1;
            termDocs.next();
            while ((term = termEnum.term()) != null && term.field().equals(latFieldName)) {
                if (termCount > xVals.capacity()) {
                    throw new IOException("Maximum number of values cannot exceed: " + xVals.capacity());
                }
                if (termCount >= length) {
                    throw new RuntimeException("There are more terms than documents in field " + latFieldName + " or " + lonFieldName + ", but its impossible to sort on tokenized fields");
                }
                termDocs.seek(termEnum);
                while (termDocs.next()) {
                    int doc = termDocs.doc();
                    float docLat = Float.parseFloat(term.text().trim());
                    Document docVal = reader.document(doc, null);
                    lonValue = docVal.get(lonFieldName);
                    if (lonValue == null) continue;
                    float docLon = Float.parseFloat(lonValue);
                    float[] coords = GeoMatchUtil.geoMatchCoordsFromDegrees(docLat, docLon);
                    this._xValArray.add(doc, coords[0]);
                    this._yValArray.add(doc, coords[1]);
                    this._zValArray.add(doc, coords[2]);
                }
                if (termEnum.next()) continue;
            }
            if (termDocs != null) {
                termDocs.close();
            }
            if (termEnum != null) {
                termEnum.close();
            }
        }
    }
}

