/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.config.NormalizeNull;
import com.azure.spring.cloud.config.implementation.AppConfigurationStatusException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

class AppConfigurationReplicaClient {
    private final String endpoint;
    private final ConfigurationClient client;
    private Instant backoffEndTime;
    private int failedAttempts;

    AppConfigurationReplicaClient(String endpoint, ConfigurationClient client) {
        this.endpoint = endpoint;
        this.client = client;
        this.backoffEndTime = Instant.now().minusMillis(1L);
        this.failedAttempts = 0;
    }

    Instant getBackoffEndTime() {
        return this.backoffEndTime;
    }

    void updateBackoffEndTime(Instant backoffEndTime) {
        this.backoffEndTime = backoffEndTime;
        ++this.failedAttempts;
    }

    int getFailedAttempts() {
        return this.failedAttempts;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    ConfigurationSetting getWatchKey(String key, String label) throws HttpResponseException {
        try {
            ConfigurationSetting watchKey = NormalizeNull.normalizeNullLabel(this.client.getConfigurationSetting(key, label));
            this.failedAttempts = 0;
            return watchKey;
        }
        catch (HttpResponseException e) {
            int statusCode = e.getResponse().getStatusCode();
            if (statusCode == 429 || statusCode == 408 || statusCode >= 500) {
                throw new AppConfigurationStatusException(e.getMessage(), e.getResponse(), e.getValue());
            }
            throw e;
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("java.net.UnknownHostException") || e.getMessage().startsWith("java.net.WebSocketHandshakeException") || e.getMessage().startsWith("java.net.SocketException") || e.getMessage().startsWith("java.io.IOException") || e.getMessage().startsWith("io.netty.channel.AbstractChannel$AnnotatedConnectException: Connection refused")) {
                throw new AppConfigurationStatusException(e.getMessage(), null, null);
            }
            throw e;
        }
    }

    List<ConfigurationSetting> listConfigurationSettings(SettingSelector settingSelector) throws HttpResponseException {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        try {
            PagedIterable settings = this.client.listConfigurationSettings(settingSelector);
            settings.forEach(setting -> configurationSettings.add((ConfigurationSetting)setting));
            this.failedAttempts = 0;
            return configurationSettings;
        }
        catch (HttpResponseException e) {
            int statusCode = e.getResponse().getStatusCode();
            if (statusCode == 429 || statusCode == 408 || statusCode >= 500) {
                throw new AppConfigurationStatusException(e.getMessage(), e.getResponse(), e.getValue());
            }
            throw e;
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("java.net.UnknownHostException") || e.getMessage().startsWith("java.net.WebSocketHandshakeException") || e.getMessage().startsWith("java.net.SocketException") || e.getMessage().startsWith("java.io.IOException") || e.getMessage().startsWith("io.netty.channel.AbstractChannel$AnnotatedConnectException: Connection refused")) {
                throw new AppConfigurationStatusException(e.getMessage(), null, null);
            }
            throw e;
        }
    }

    void updateSyncToken(String syncToken) {
        if (syncToken != null) {
            this.client.updateSyncToken(syncToken);
        }
    }
}

