/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.config.implementation.AppConfigurationPullRefresh;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.config.implementation.ConnectionManager;
import com.azure.spring.cloud.config.implementation.State;
import com.azure.spring.cloud.config.implementation.StateHolder;
import com.azure.spring.cloud.config.pipline.policies.BaseAppConfigurationPolicy;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.config.properties.FeatureFlagStore;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppConfigurationRefreshUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPullRefresh.class);

    AppConfigurationRefreshUtil() {
    }

    static RefreshEventData refreshStoresCheck(AppConfigurationReplicaClientFactory clientFactory, Duration refreshInterval, Long defaultMinBackoff) {
        RefreshEventData eventData = new RefreshEventData();
        BaseAppConfigurationPolicy.setWatchRequests(true);
        try {
            if (refreshInterval != null && StateHolder.getNextForcedRefresh() != null && Instant.now().isAfter(StateHolder.getNextForcedRefresh())) {
                String eventDataInfo = "Minimum refresh period reached. Refreshing configurations.";
                LOGGER.info(eventDataInfo);
                eventData.setMessage(eventDataInfo);
            }
            block6: for (Map.Entry entry : clientFactory.getConnections().entrySet()) {
                String originEndpoint = (String)entry.getKey();
                ConnectionManager connection = (ConnectionManager)entry.getValue();
                clientFactory.setCurrentConfigStoreClient(originEndpoint, originEndpoint);
                AppConfigurationStoreMonitoring monitor = connection.getMonitoring();
                List<AppConfigurationReplicaClient> clients = clientFactory.getAvailableClients(originEndpoint);
                if (monitor.isEnabled() && StateHolder.getLoadState(originEndpoint)) {
                    for (AppConfigurationReplicaClient client : clients) {
                        try {
                            AppConfigurationRefreshUtil.refreshWithTime(client, StateHolder.getState(originEndpoint), monitor.getRefreshInterval(), eventData);
                            if (eventData.getDoRefresh()) {
                                clientFactory.setCurrentConfigStoreClient(originEndpoint, client.getEndpoint());
                                return eventData;
                            }
                            break;
                        }
                        catch (AppConfigurationStatusException e) {
                            LOGGER.warn("Failed attempting to connect to " + client.getEndpoint() + " during refresh check.");
                            clientFactory.backoffClient(originEndpoint, client.getEndpoint());
                        }
                    }
                } else {
                    LOGGER.debug("Skipping configuration refresh check for " + originEndpoint);
                }
                FeatureFlagStore featureStore = connection.getFeatureFlagStore();
                if (featureStore.getEnabled().booleanValue() && StateHolder.getLoadStateFeatureFlag(originEndpoint)) {
                    for (AppConfigurationReplicaClient client : clients) {
                        try {
                            AppConfigurationRefreshUtil.refreshWithTimeFeatureFlags(client, featureStore, StateHolder.getStateFeatureFlag(originEndpoint), monitor.getFeatureFlagRefreshInterval(), eventData);
                            if (!eventData.getDoRefresh()) continue block6;
                            clientFactory.setCurrentConfigStoreClient(originEndpoint, client.getEndpoint());
                            return eventData;
                        }
                        catch (AppConfigurationStatusException e) {
                            LOGGER.warn("Failed attempting to connect to " + client.getEndpoint() + " durring refresh check.");
                            clientFactory.backoffClient(originEndpoint, client.getEndpoint());
                        }
                    }
                    continue;
                }
                LOGGER.debug("Skipping feature flag refresh check for " + originEndpoint);
            }
        }
        catch (Exception e) {
            StateHolder.getCurrentState().updateNextRefreshTime(refreshInterval, defaultMinBackoff);
            throw e;
        }
        return eventData;
    }

    static boolean checkStoreAfterRefreshFailed(AppConfigurationReplicaClient client, AppConfigurationReplicaClientFactory clientFactory, FeatureFlagStore featureStore) {
        return AppConfigurationRefreshUtil.refreshStoreCheck(client, clientFactory.findOriginForEndpoint(client.getEndpoint())) || AppConfigurationRefreshUtil.refreshStoreFeatureFlagCheck(featureStore, client);
    }

    private static boolean refreshStoreCheck(AppConfigurationReplicaClient client, String originEndpoint) {
        RefreshEventData eventData = new RefreshEventData();
        if (StateHolder.getLoadState(originEndpoint)) {
            AppConfigurationRefreshUtil.refreshWithoutTime(client, StateHolder.getState(originEndpoint).getWatchKeys(), eventData);
        }
        return eventData.getDoRefresh();
    }

    private static boolean refreshStoreFeatureFlagCheck(FeatureFlagStore featureStore, AppConfigurationReplicaClient client) {
        RefreshEventData eventData = new RefreshEventData();
        String endpoint = client.getEndpoint();
        if (featureStore.getEnabled().booleanValue() && StateHolder.getLoadStateFeatureFlag(endpoint)) {
            AppConfigurationRefreshUtil.refreshWithoutTimeFeatureFlags(client, featureStore, StateHolder.getStateFeatureFlag(endpoint).getWatchKeys(), eventData);
        } else {
            LOGGER.debug("Skipping feature flag refresh check for " + endpoint);
        }
        return eventData.getDoRefresh();
    }

    private static void refreshWithTime(AppConfigurationReplicaClient client, State state, Duration refreshInterval, RefreshEventData eventData) throws AppConfigurationStatusException {
        if (Instant.now().isAfter(state.getNextRefreshCheck())) {
            AppConfigurationRefreshUtil.refreshWithoutTime(client, state.getWatchKeys(), eventData);
            if (eventData.getDoRefresh()) {
                StateHolder.getCurrentState().updateStateRefresh(state, refreshInterval);
            }
        }
    }

    private static void refreshWithoutTime(AppConfigurationReplicaClient client, List<ConfigurationSetting> watchKeys, RefreshEventData eventData) throws AppConfigurationStatusException {
        for (ConfigurationSetting watchKey : watchKeys) {
            ConfigurationSetting watchedKey = client.getWatchKey(watchKey.getKey(), watchKey.getLabel());
            if (watchedKey == null) continue;
            AppConfigurationRefreshUtil.checkETag(watchKey, watchedKey, client.getEndpoint(), eventData);
            if (!eventData.getDoRefresh()) continue;
            break;
        }
    }

    private static void refreshWithTimeFeatureFlags(AppConfigurationReplicaClient client, FeatureFlagStore featureStore, State state, Duration refreshInterval, RefreshEventData eventData) throws AppConfigurationStatusException {
        Instant date = Instant.now();
        if (date.isAfter(state.getNextRefreshCheck())) {
            SettingSelector selector = new SettingSelector().setKeyFilter(featureStore.getKeyFilter()).setLabelFilter(featureStore.getLabelFilter());
            List<ConfigurationSetting> currentKeys = client.listConfigurationSettings(selector);
            int watchedKeySize = 0;
            block0: for (ConfigurationSetting currentKey : currentKeys) {
                ++watchedKeySize;
                for (ConfigurationSetting watchFlag : state.getWatchKeys()) {
                    if (watchFlag == null || !watchFlag.getKey().equals(currentKey.getKey()) || !watchFlag.getLabel().equals(currentKey.getLabel())) continue;
                    AppConfigurationRefreshUtil.checkETag(watchFlag, currentKey, client.getEndpoint(), eventData);
                    if (!eventData.getDoRefresh()) continue;
                    break block0;
                }
            }
            if (watchedKeySize != state.getWatchKeys().size()) {
                String eventDataInfo = ".appconfig.featureflag/*";
                LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
                eventData.setMessage(eventDataInfo);
            }
            StateHolder.getCurrentState().updateStateRefresh(state, refreshInterval);
        }
    }

    private static void refreshWithoutTimeFeatureFlags(AppConfigurationReplicaClient client, FeatureFlagStore featureStore, List<ConfigurationSetting> watchKeys, RefreshEventData eventData) throws AppConfigurationStatusException {
        SettingSelector selector = new SettingSelector().setKeyFilter(featureStore.getKeyFilter()).setLabelFilter(featureStore.getLabelFilter());
        List<ConfigurationSetting> currentTriggerConfigurations = client.listConfigurationSettings(selector);
        int watchedKeySize = 0;
        for (ConfigurationSetting currentTriggerConfiguration : currentTriggerConfigurations) {
            ++watchedKeySize;
            for (ConfigurationSetting watchFlag : watchKeys) {
                if (watchFlag == null || !watchFlag.getKey().equals(currentTriggerConfiguration.getKey()) || !watchFlag.getLabel().equals(currentTriggerConfiguration.getLabel())) break;
                AppConfigurationRefreshUtil.checkETag(watchFlag, currentTriggerConfiguration, client.getEndpoint(), eventData);
                if (!eventData.getDoRefresh()) continue;
                return;
            }
        }
        if (watchedKeySize != watchKeys.size()) {
            String eventDataInfo = ".appconfig.featureflag/*";
            LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
            eventData.setMessage(eventDataInfo);
        }
    }

    private static void checkETag(ConfigurationSetting watchSetting, ConfigurationSetting currentTriggerConfiguration, String endpoint, RefreshEventData eventData) {
        if (currentTriggerConfiguration == null) {
            return;
        }
        LOGGER.debug(watchSetting.getETag(), (Object)" - ", (Object)currentTriggerConfiguration.getETag());
        if (watchSetting.getETag() != null && !watchSetting.getETag().equals(currentTriggerConfiguration.getETag())) {
            LOGGER.trace("Some keys in store [{}] matching the key [{}] and label [{}] is updated, will send refresh event.", new Object[]{endpoint, watchSetting.getKey(), watchSetting.getLabel()});
            String eventDataInfo = watchSetting.getKey();
            LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
            eventData.setMessage(eventDataInfo);
        }
    }

    static class RefreshEventData {
        private static final String MSG_TEMPLATE = "Some keys matching %s has been updated since last check.";
        private String message = "";
        private boolean doRefresh = false;

        RefreshEventData() {
        }

        RefreshEventData setMessage(String prefix) {
            this.message = String.format(MSG_TEMPLATE, prefix);
            this.doRefresh = true;
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean getDoRefresh() {
            return this.doRefresh;
        }
    }
}

