/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.stores;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.resource.AppConfigManagedIdentityProperties;
import java.net.URI;
import java.time.Duration;
import org.springframework.util.StringUtils;

public final class KeyVaultClient {
    private SecretAsyncClient secretClient;
    private final AppConfigurationProperties properties;
    private final SecretClientBuilderSetup keyVaultClientProvider;
    private final URI uri;
    private final TokenCredential tokenCredential;
    private final KeyVaultSecretProvider keyVaultSecretProvider;
    private Boolean useSecretResolver = false;

    public KeyVaultClient(AppConfigurationProperties properties, URI uri, KeyVaultCredentialProvider tokenCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider, KeyVaultSecretProvider keyVaultSecretProvider) {
        this.properties = properties;
        this.uri = uri;
        this.tokenCredential = tokenCredentialProvider != null ? tokenCredentialProvider.getKeyVaultCredential("https://" + uri.getHost()) : null;
        this.keyVaultClientProvider = keyVaultClientProvider;
        this.keyVaultSecretProvider = keyVaultSecretProvider;
    }

    KeyVaultClient build() {
        SecretClientBuilder builder = this.getBuilder();
        AppConfigManagedIdentityProperties msiProps = this.properties.getManagedIdentity();
        String fullUri = "https://" + this.uri.getHost();
        if (this.tokenCredential != null && msiProps != null) {
            throw new IllegalArgumentException("More than 1 Conncetion method was set for connecting to Key Vault.");
        }
        if (this.tokenCredential != null) {
            builder.credential(this.tokenCredential);
        } else if (msiProps != null && StringUtils.hasText((String)msiProps.getClientId())) {
            builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().clientId(msiProps.getClientId()).build());
        } else if (this.keyVaultSecretProvider != null) {
            this.useSecretResolver = true;
        } else {
            builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().build());
        }
        builder.vaultUrl(fullUri);
        if (this.keyVaultClientProvider != null) {
            this.keyVaultClientProvider.setup(builder, fullUri);
        }
        if (!this.useSecretResolver.booleanValue()) {
            this.secretClient = builder.buildAsyncClient();
        }
        return this;
    }

    public KeyVaultSecret getSecret(URI secretIdentifier, int timeout) {
        if (this.secretClient == null && !this.useSecretResolver.booleanValue()) {
            this.build();
        }
        if (this.useSecretResolver.booleanValue()) {
            return new KeyVaultSecret(null, this.keyVaultSecretProvider.getSecret(secretIdentifier.getRawPath()));
        }
        String[] tokens = secretIdentifier.getPath().split("/");
        String name = tokens.length >= 3 ? tokens[2] : null;
        String version = tokens.length >= 4 ? tokens[3] : null;
        return (KeyVaultSecret)this.secretClient.getSecret(name, version).block(Duration.ofSeconds(timeout));
    }

    SecretClientBuilder getBuilder() {
        return new SecretClientBuilder();
    }
}

