/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.fluent.models.PrivateEndpointConnectionProperties;
import com.azure.resourcemanager.keyvault.models.PrivateEndpoint;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.keyvault.models.PrivateLinkServiceConnectionState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class PrivateEndpointConnectionItem {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateEndpointConnectionItem.class);
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="properties")
    private PrivateEndpointConnectionProperties innerProperties;

    public String id() {
        return this.id;
    }

    public PrivateEndpointConnectionItem withId(String id) {
        this.id = id;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public PrivateEndpointConnectionItem withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    private PrivateEndpointConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public PrivateEndpoint privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    public PrivateEndpointConnectionItem withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public PrivateEndpointConnectionItem withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

