/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.util.CoreUtils;
import com.azure.data.tables.implementation.StorageConstants;
import com.azure.data.tables.implementation.TableSasUtils;
import com.azure.data.tables.sas.TableAccountSasPermission;
import com.azure.data.tables.sas.TableAccountSasSignatureValues;
import com.azure.data.tables.sas.TableSasIpRange;
import com.azure.data.tables.sas.TableSasProtocol;
import java.time.OffsetDateTime;
import java.util.Objects;

public class TableAccountSasGenerator {
    private final OffsetDateTime expiryTime;
    private final OffsetDateTime startTime;
    private final String permissions;
    private final String resourceTypes;
    private final String services;
    private final String sas;
    private final TableSasProtocol protocol;
    private final TableSasIpRange sasIpRange;
    private String version;

    public TableAccountSasGenerator(TableAccountSasSignatureValues sasValues, AzureNamedKeyCredential azureNamedKeyCredential) {
        Objects.requireNonNull(sasValues, "'sasValues' cannot be null.");
        Objects.requireNonNull(azureNamedKeyCredential, "'azureNamedKeyCredential' cannot be null.");
        Objects.requireNonNull(sasValues.getServices(), "'services' in 'sasValues' cannot be null.");
        Objects.requireNonNull(sasValues.getResourceTypes(), "'resourceTypes' in 'sasValues' cannot be null.");
        Objects.requireNonNull(sasValues.getExpiryTime(), "'expiryTime' in 'sasValues' cannot be null.");
        Objects.requireNonNull(sasValues.getPermissions(), "'permissions' in 'sasValues' cannot be null.");
        this.version = sasValues.getVersion();
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.services = sasValues.getServices();
        this.resourceTypes = sasValues.getResourceTypes();
        if (CoreUtils.isNullOrEmpty((CharSequence)this.version)) {
            this.version = "2020-04-08";
        }
        String stringToSign = this.stringToSign(azureNamedKeyCredential);
        String signature = TableSasUtils.computeHmac256(azureNamedKeyCredential.getAzureNamedKey().getKey(), stringToSign);
        this.sas = this.encode(signature);
    }

    public String getSas() {
        return this.sas;
    }

    private String stringToSign(AzureNamedKeyCredential azureNamedKeyCredential) {
        return String.join((CharSequence)"\n", azureNamedKeyCredential.getAzureNamedKey().getName(), TableAccountSasPermission.parse(this.permissions).toString(), this.services, this.resourceTypes, this.startTime == null ? "" : StorageConstants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), StorageConstants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, "");
    }

    private String encode(String signature) {
        StringBuilder sb = new StringBuilder();
        TableSasUtils.tryAppendQueryParameter(sb, "sv", this.version);
        TableSasUtils.tryAppendQueryParameter(sb, "ss", this.services);
        TableSasUtils.tryAppendQueryParameter(sb, "srt", this.resourceTypes);
        TableSasUtils.tryAppendQueryParameter(sb, "st", TableSasUtils.formatQueryParameterDate(this.startTime));
        TableSasUtils.tryAppendQueryParameter(sb, "se", TableSasUtils.formatQueryParameterDate(this.expiryTime));
        TableSasUtils.tryAppendQueryParameter(sb, "sp", this.permissions);
        TableSasUtils.tryAppendQueryParameter(sb, "sip", this.sasIpRange);
        TableSasUtils.tryAppendQueryParameter(sb, "spr", (Object)this.protocol);
        TableSasUtils.tryAppendQueryParameter(sb, "sig", signature);
        return sb.toString();
    }
}

