/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.MessageProducerSession;
import com.atomikos.jms.QueueConnectionFactoryBean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;

public class QueueSenderSession
extends MessageProducerSession {
    public void setReplyToQueue(Queue queue) {
        this.setReplyToDestination((Destination)queue);
    }

    public Queue getReplyToQueue() {
        Queue ret = null;
        Destination dest = this.getReplyToDestination();
        if (dest instanceof Queue) {
            ret = (Queue)dest;
        }
        return ret;
    }

    public Queue getQueue() {
        return (Queue)this.getDestination();
    }

    public QueueConnectionFactoryBean getQueueConnectionFactoryBean() {
        return (QueueConnectionFactoryBean)this.getAbstractConnectionFactoryBean();
    }

    public void setQueue(Queue queue) {
        this.setDestination((Destination)queue);
    }

    public void setQueueConnectionFactoryBean(QueueConnectionFactoryBean bean) {
        this.setAbstractConnectionFactoryBean(bean);
    }

    protected String getDestinationName() {
        String ret = null;
        Queue q = this.getQueue();
        if (q != null) {
            try {
                ret = q.getQueueName();
            }
            catch (JMSException e) {
                Configuration.logDebug((String)"QueueSenderSession: error retrieving queue name", (Throwable)e);
            }
        }
        return ret;
    }

    protected String getReplyToDestinationName() {
        String ret = null;
        Queue q = this.getReplyToQueue();
        if (q != null) {
            try {
                ret = q.getQueueName();
            }
            catch (JMSException e) {
                Configuration.logDebug((String)"QueueSenderSession: error retrieving queue name", (Throwable)e);
            }
        }
        return ret;
    }
}

