/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.jms.DefaultJtaMessageProducer;
import com.atomikos.jms.HeuristicTopicPublisher;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.transaction.xa.XAResource;

class JtaTopicPublisher
extends DefaultJtaMessageProducer
implements HeuristicTopicPublisher {
    JtaTopicPublisher(TopicPublisher publisher, TransactionalResource res, XAResource xares) {
        super((MessageProducer)publisher, res, xares);
    }

    public void publish(Message msg, HeuristicMessage hmsg) throws JMSException {
        this.sendToDefaultDestination(msg, hmsg);
    }

    public void publish(Message msg, int deliveryMode, int priority, long timeToLive, HeuristicMessage hmsg) throws JMSException {
        this.sendToDefaultDestination(msg, deliveryMode, priority, timeToLive, hmsg);
    }

    public void publish(Topic t, Message msg, HeuristicMessage hmsg) throws JMSException {
        this.sendToDestination((Destination)t, msg, hmsg);
    }

    public void publish(Topic t, Message msg, int deliveryMode, int priority, long timeToLive, HeuristicMessage hmsg) throws JMSException {
        this.sendToDestination((Destination)t, msg, deliveryMode, priority, timeToLive, hmsg);
    }

    public void publish(Message msg, String hmsg) throws JMSException {
        StringHeuristicMessage shmsg = new StringHeuristicMessage(hmsg);
        this.sendToDefaultDestination(msg, (HeuristicMessage)shmsg);
    }

    public void publish(Message msg, int deliveryMode, int priority, long timeToLive, String hmsg) throws JMSException {
        StringHeuristicMessage shmsg = new StringHeuristicMessage(hmsg);
        this.sendToDefaultDestination(msg, deliveryMode, priority, timeToLive, (HeuristicMessage)shmsg);
    }

    public void publish(Topic t, Message msg, String hmsg) throws JMSException {
        StringHeuristicMessage shmsg = new StringHeuristicMessage(hmsg);
        this.sendToDestination((Destination)t, msg, (HeuristicMessage)shmsg);
    }

    public void publish(Topic t, Message msg, int deliveryMode, int priority, long timeToLive, String hmsg) throws JMSException {
        StringHeuristicMessage shmsg = new StringHeuristicMessage(hmsg);
        this.sendToDestination((Destination)t, msg, deliveryMode, priority, timeToLive, (HeuristicMessage)shmsg);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(Message msg) throws JMSException {
        this.send(msg);
    }

    public void publish(Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send(msg, deliveryMode, priority, ttl);
    }

    public void publish(Topic t, Message msg) throws JMSException {
        this.send((Destination)t, msg);
    }

    public void publish(Topic t, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send((Destination)t, msg, deliveryMode, priority, ttl);
    }
}

