/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.datasource.xa.jms.JmsTransactionalResource;
import com.atomikos.jms.JndiObjectFactory;
import com.atomikos.jms.JtaTopicConnection;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class JtaTopicConnectionFactory
implements TopicConnectionFactory,
Referenceable {
    private static HashMap nameToFactory_ = new HashMap();
    private XATopicConnectionFactory factory_;
    private JmsTransactionalResource res_;

    static Reference createReference(String uniqueName) {
        StringRefAddr ra = new StringRefAddr("ResourceName", uniqueName);
        Reference ref = new Reference(JtaTopicConnectionFactory.class.getName(), new StringRefAddr("name", "JtaTopicConnectionFactory"), JndiObjectFactory.class.getName(), null);
        ref.add(ra);
        return ref;
    }

    static JtaTopicConnectionFactory getInstance(String name) {
        JtaTopicConnectionFactory ret = (JtaTopicConnectionFactory)nameToFactory_.get(name);
        if (ret != null && ret.getTransactionalResource().isClosed()) {
            JtaTopicConnectionFactory.removeFromMap(name);
            ret = null;
        }
        return ret;
    }

    static synchronized JtaTopicConnectionFactory getOrCreate(String resourceName, XATopicConnectionFactory qFactory, XidFactory xFactory) {
        JtaTopicConnectionFactory ret = JtaTopicConnectionFactory.getInstance(resourceName);
        if (ret == null) {
            ret = new JtaTopicConnectionFactory(resourceName, qFactory, xFactory);
            JtaTopicConnectionFactory.addToMap(resourceName, ret);
        }
        return ret;
    }

    private static synchronized void addToMap(String name, JtaTopicConnectionFactory instance) {
        nameToFactory_.put(name, instance);
    }

    private static synchronized void removeFromMap(String name) {
        nameToFactory_.remove(name);
    }

    public JtaTopicConnectionFactory(String resourceName, XATopicConnectionFactory factory) {
        this.factory_ = factory;
        this.res_ = new JmsTransactionalResource(resourceName, (XAConnectionFactory)factory);
        JtaTopicConnectionFactory.addToMap(this.res_.getName(), this);
    }

    public JtaTopicConnectionFactory(String resourceName, XATopicConnectionFactory tFactory, XidFactory xFactory) {
        this.factory_ = tFactory;
        this.res_ = new JmsTransactionalResource(resourceName, (XAConnectionFactory)tFactory, xFactory);
        JtaTopicConnectionFactory.addToMap(this.res_.getName(), this);
    }

    public JmsTransactionalResource getTransactionalResource() {
        return this.res_;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        XATopicConnection tc = this.factory_.createXATopicConnection();
        return new JtaTopicConnection(tc, (TransactionalResource)this.res_);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        XATopicConnection tc = this.factory_.createXATopicConnection(userName, password);
        return new JtaTopicConnection(tc, (TransactionalResource)this.res_);
    }

    public Connection createConnection() throws JMSException {
        return this.createTopicConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createTopicConnection(userName, password);
    }

    public Reference getReference() throws NamingException {
        return JtaTopicConnectionFactory.createReference(this.res_.getName());
    }
}

