/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.HeuristicMessageConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.transaction.xa.XAResource;

class DefaultJtaMessageConsumer
implements HeuristicMessageConsumer {
    private MessageConsumer receiver_;
    private TransactionalResource res_;
    private XAResourceTransaction restx_;
    private XAResource xares_;

    DefaultJtaMessageConsumer(MessageConsumer receiver, TransactionalResource res, XAResource xares) {
        this.receiver_ = receiver;
        this.res_ = res;
        this.xares_ = xares;
    }

    protected MessageConsumer getMessageConsumer() {
        return this.receiver_;
    }

    private synchronized void enlist() throws JMSException {
        if (this.restx_ != null) {
            throw new JMSException("JtaMessageConsumer.enlist: already enlisted");
        }
        CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
        if (ctm == null) {
            throw new JMSException("JtaMessageConsumer: requires Atomikos TransactionsEssentials to be running! Please make sure to start a transaction first.");
        }
        CompositeTransaction ct = ctm.getCompositeTransaction();
        if (ct == null || ct.getProperty("com.atomikos.icatch.jta.transaction") == null) {
            throw new JMSException("JTA transaction required for JtaMessageConsumer");
        }
        this.restx_ = (XAResourceTransaction)this.res_.getResourceTransaction(ct);
        this.restx_.setXAResource(this.xares_);
        this.restx_.resume();
    }

    private synchronized void delist(HeuristicMessage msg) throws JMSException {
        if (this.restx_ == null) {
            throw new JMSException("JtaMessageConsumer.delist: not enlisted");
        }
        if (msg != null) {
            this.restx_.addHeuristicMessage(msg);
        }
        this.restx_.suspend();
        this.restx_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(HeuristicMessage hmsg) throws JMSException {
        Message ret = null;
        this.enlist();
        try {
            ret = this.receiver_.receive();
            if (hmsg == null && ret != null) {
                hmsg = new StringHeuristicMessage("Receipt of JMS Message with JMS ID : " + ret.getJMSMessageID());
            }
        }
        finally {
            this.delist(hmsg);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(HeuristicMessage hmsg, long timeout) throws JMSException {
        Message ret = null;
        this.enlist();
        try {
            ret = this.receiver_.receive(timeout);
        }
        finally {
            this.delist(hmsg);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait(HeuristicMessage hmsg) throws JMSException {
        Message ret = null;
        this.enlist();
        try {
            ret = this.receiver_.receiveNoWait();
        }
        finally {
            this.delist(hmsg);
        }
        return ret;
    }

    public Message receiveNoWait() throws JMSException {
        HeuristicMessage msg = null;
        return this.receiveNoWait(msg);
    }

    public Message receive(long timeout) throws JMSException {
        HeuristicMessage msg = null;
        return this.receive(msg, timeout);
    }

    public String getMessageSelector() throws JMSException {
        return this.receiver_.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.receiver_.getMessageListener();
    }

    public void setMessageListener(MessageListener l) throws JMSException {
        this.receiver_.setMessageListener(l);
    }

    public void close() throws JMSException {
        this.receiver_.close();
    }

    public Message receive(String hmsg) throws JMSException {
        StringHeuristicMessage msg = new StringHeuristicMessage(hmsg);
        return this.receive((HeuristicMessage)msg);
    }

    public Message receive(String hmsg, long timeout) throws JMSException {
        StringHeuristicMessage msg = new StringHeuristicMessage(hmsg);
        return this.receive((HeuristicMessage)msg, timeout);
    }

    public Message receiveNoWait(String hmsg) throws JMSException {
        StringHeuristicMessage msg = new StringHeuristicMessage(hmsg);
        return this.receiveNoWait((HeuristicMessage)msg);
    }

    public Message receive() throws JMSException {
        HeuristicMessage msg = null;
        return this.receive(msg);
    }

    public Message receive(long timeout, String hmsg) throws JMSException {
        return this.receive(hmsg, timeout);
    }
}

