/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.local;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.SystemImage;
import com.android.sdklib.internal.androidTarget.PlatformTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PlatformPackage;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.local.LocalAndroidVersionPkgInfo;
import com.android.sdklib.local.LocalPkgInfo;
import com.android.sdklib.local.LocalSdk;
import com.android.sdklib.local.LocalSysImgPkgInfo;
import com.android.sdklib.repository.MajorRevision;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class LocalPlatformPkgInfo
extends LocalAndroidVersionPkgInfo {
    public static final String PROP_VERSION_SDK = "ro.build.version.sdk";
    public static final String PROP_VERSION_CODENAME = "ro.build.version.codename";
    public static final String PROP_VERSION_RELEASE = "ro.build.version.release";
    private final MajorRevision mRevision;
    private IAndroidTarget mTarget;
    private boolean mLoaded;
    private static final String[] sPlatformContentList = new String[]{"android.jar", "framework.aidl"};

    public LocalPlatformPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps, @NonNull AndroidVersion version, @NonNull MajorRevision revision) {
        super(localSdk, localDir, sourceProps, version);
        this.mRevision = revision;
    }

    @Override
    public int getType() {
        return 256;
    }

    @Override
    public boolean hasPath() {
        return true;
    }

    @Override
    public String getPath() {
        return this.getTargetHash();
    }

    @NonNull
    public String getTargetHash() {
        return AndroidTargetHash.getPlatformHashString(this.getAndroidVersion());
    }

    @Nullable
    public IAndroidTarget getAndroidTarget() {
        if (!this.mLoaded) {
            this.mTarget = this.createAndroidTarget();
            this.mLoaded = true;
        }
        return this.mTarget;
    }

    public boolean isLoaded() {
        return this.mLoaded;
    }

    @Override
    public boolean hasMajorRevision() {
        return true;
    }

    @Override
    public MajorRevision getMajorRevision() {
        return this.mRevision;
    }

    @Override
    public Package getPackage() {
        Package pkg = super.getPackage();
        if (pkg != null) {
            return pkg;
        }
        pkg = this.createPackage();
        this.setPackage(pkg);
        return pkg;
    }

    @Nullable
    protected Package createPackage() {
        IAndroidTarget target = this.getAndroidTarget();
        if (target != null) {
            return PlatformPackage.create(target, this.getSourceProperties());
        }
        return null;
    }

    @Nullable
    protected IAndroidTarget createAndroidTarget() {
        LocalPkgInfo sources;
        int apiNumber;
        String stringValue;
        LocalSdk sdk = this.getLocalSdk();
        IFileOp fileOp = sdk.getFileOp();
        File platformFolder = this.getLocalDir();
        File buildProp = new File(platformFolder, "build.prop");
        File sourcePropFile = new File(platformFolder, "source.properties");
        if (!fileOp.isFile(buildProp) || !fileOp.isFile(sourcePropFile)) {
            this.appendLoadError("Ignoring platform '%1$s': %2$s is missing.", platformFolder.getName(), "build.prop");
            return null;
        }
        HashMap<String, String> platformProp = new HashMap<String, String>();
        Map<String, String> map = null;
        try {
            map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(buildProp), buildProp.getPath(), null);
            if (map != null) {
                platformProp.putAll(map);
            }
        }
        catch (FileNotFoundException ignore) {
            // empty catch block
        }
        try {
            map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(sourcePropFile), sourcePropFile.getPath(), null);
            if (map != null) {
                platformProp.putAll(map);
            }
        }
        catch (FileNotFoundException ignore) {
            // empty catch block
        }
        File sdkPropFile = new File(platformFolder, "sdk.properties");
        if (fileOp.isFile(sdkPropFile)) {
            try {
                map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(sdkPropFile), sdkPropFile.getPath(), null);
                if (map != null) {
                    platformProp.putAll(map);
                }
            }
            catch (FileNotFoundException ignore) {
                // empty catch block
            }
        }
        if ((stringValue = (String)platformProp.get(PROP_VERSION_SDK)) == null) {
            this.appendLoadError("Ignoring platform '%1$s': %2$s is missing from '%3$s'", platformFolder.getName(), PROP_VERSION_SDK, "build.prop");
            return null;
        }
        try {
            apiNumber = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            this.appendLoadError("Ignoring platform '%1$s': %2$s is not a valid number in %3$s.", platformFolder.getName(), PROP_VERSION_SDK, "build.prop");
            return null;
        }
        AndroidVersion apiVersion = new AndroidVersion(apiNumber, (String)platformProp.get(PROP_VERSION_CODENAME));
        String apiName = (String)platformProp.get("Platform.Version");
        if (apiName == null) {
            apiName = (String)platformProp.get(PROP_VERSION_RELEASE);
        }
        if (apiName == null) {
            this.appendLoadError("Ignoring platform '%1$s': %2$s is missing from '%3$s'", platformFolder.getName(), PROP_VERSION_RELEASE, "build.prop");
            return null;
        }
        int revision = 1;
        SdkManager.LayoutlibVersion layoutlibVersion = null;
        try {
            revision = Integer.parseInt((String)platformProp.get("Pkg.Revision"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            int llRev;
            String propApi = (String)platformProp.get("Layoutlib.Api");
            String propRev = (String)platformProp.get("Layoutlib.Revision");
            int llApi = propApi == null ? 0 : Integer.parseInt(propApi);
            int n = llRev = propRev == null ? 0 : Integer.parseInt(propRev);
            if (llApi > 0 && llRev >= 0) {
                layoutlibVersion = new SdkManager.LayoutlibVersion(llApi, llRev);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String err = LocalPlatformPkgInfo.checkPlatformContent(fileOp, platformFolder);
        if (err != null) {
            this.appendLoadError("%s", err);
            return null;
        }
        ISystemImage[] systemImages = this.getPlatformSystemImages(fileOp, platformFolder, apiVersion);
        PlatformTarget pt = new PlatformTarget(sdk.getLocation().getPath(), platformFolder.getAbsolutePath(), apiVersion, apiName, revision, layoutlibVersion, systemImages, platformProp, sdk.getLatestBuildTool());
        String[] skins = this.parseSkinFolder(pt.getPath(5));
        pt.setSkins(skins);
        LocalPkgInfo samples = sdk.getPkgInfo(2048, this.getAndroidVersion());
        if (samples != null) {
            pt.setSamplesPath(samples.getLocalDir().getAbsolutePath());
        }
        if ((sources = sdk.getPkgInfo(4096, this.getAndroidVersion())) != null) {
            pt.setSourcesPath(sources.getLocalDir().getAbsolutePath());
        }
        return pt;
    }

    @NonNull
    private ISystemImage[] getPlatformSystemImages(IFileOp fileOp, File platformDir, AndroidVersion apiVersion) {
        TreeSet<SystemImage> found = new TreeSet<SystemImage>();
        HashSet<String> abiFound = new HashSet<String>();
        for (LocalPkgInfo pkg : this.getLocalSdk().getPkgsInfos(512)) {
            String abi;
            if (!(pkg instanceof LocalSysImgPkgInfo) || !apiVersion.equals(pkg.getAndroidVersion()) || (abi = ((LocalSysImgPkgInfo)pkg).getAbi()) == null || abiFound.contains(abi)) continue;
            found.add(new SystemImage(pkg.getLocalDir(), ISystemImage.LocationType.IN_SYSTEM_IMAGE, abi));
            abiFound.add(abi);
        }
        File imgDir = new File(platformDir, SdkConstants.OS_IMAGES_FOLDER);
        File[] files = fileOp.listFiles(imgDir);
        boolean useLegacy = true;
        boolean hasImgFiles = false;
        for (File file : files) {
            if (fileOp.isDirectory(file)) {
                useLegacy = false;
                String abi = file.getName();
                if (abiFound.contains(abi)) continue;
                found.add(new SystemImage(file, ISystemImage.LocationType.IN_PLATFORM_SUBFOLDER, abi));
                abiFound.add(abi);
                continue;
            }
            if (hasImgFiles || !fileOp.isFile(file) || !file.getName().endsWith(".img")) continue;
            hasImgFiles = true;
        }
        if (useLegacy && hasImgFiles && fileOp.isDirectory(imgDir) && !abiFound.contains("armeabi")) {
            found.add(new SystemImage(imgDir, ISystemImage.LocationType.IN_PLATFORM_LEGACY, "armeabi"));
        }
        return found.toArray(new ISystemImage[found.size()]);
    }

    @NonNull
    protected String[] parseSkinFolder(@NonNull String osPath) {
        File skinRootFolder;
        IFileOp fileOp = this.getLocalSdk().getFileOp();
        if (fileOp.isDirectory(skinRootFolder = new File(osPath))) {
            File[] files;
            ArrayList<String> skinList = new ArrayList<String>();
            for (File skinFolder : files = fileOp.listFiles(skinRootFolder)) {
                File layout;
                if (!fileOp.isDirectory(skinFolder) || !fileOp.isFile(layout = new File(skinFolder, "layout"))) continue;
                skinList.add(skinFolder.getName());
            }
            return skinList.toArray(new String[skinList.size()]);
        }
        return new String[0];
    }

    @NonNull
    private static String checkPlatformContent(IFileOp fileOp, @NonNull File platform) {
        for (String relativePath : sPlatformContentList) {
            File f = new File(platform, relativePath);
            if (fileOp.exists(f)) continue;
            return String.format("Ignoring platform '%1$s': %2$s is missing.", platform.getName(), relativePath);
        }
        return null;
    }
}

