/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.local;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.IListDescription;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.local.LocalSdk;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import java.io.File;
import java.util.Properties;

public abstract class LocalPkgInfo
implements IListDescription,
Comparable<LocalPkgInfo> {
    private final LocalSdk mLocalSdk;
    private final File mLocalDir;
    private final Properties mSourceProperties;
    private Package mPackage;
    private String mLoadError;

    protected LocalPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps) {
        this.mLocalSdk = localSdk;
        this.mLocalDir = localDir;
        this.mSourceProperties = sourceProps;
    }

    @NonNull
    public LocalSdk getLocalSdk() {
        return this.mLocalSdk;
    }

    @NonNull
    public File getLocalDir() {
        return this.mLocalDir;
    }

    @NonNull
    public Properties getSourceProperties() {
        return this.mSourceProperties;
    }

    @Nullable
    public String getLoadError() {
        return this.mLoadError;
    }

    public abstract int getType();

    public boolean hasFullRevision() {
        return false;
    }

    public boolean hasMajorRevision() {
        return false;
    }

    public boolean hasAndroidVersion() {
        return false;
    }

    public boolean hasPath() {
        return false;
    }

    @Nullable
    public FullRevision getFullRevision() {
        return null;
    }

    @Nullable
    public MajorRevision getMajorRevision() {
        return null;
    }

    @Nullable
    public AndroidVersion getAndroidVersion() {
        return null;
    }

    @Nullable
    public String getPath() {
        return null;
    }

    @Override
    public int compareTo(@NonNull LocalPkgInfo o) {
        int t2;
        int t1 = this.getType();
        if (t1 != (t2 = o.getType())) {
            return t2 - t1;
        }
        if (this.hasAndroidVersion() && o.hasAndroidVersion() && (t1 = this.getAndroidVersion().compareTo(o.getAndroidVersion())) != 0) {
            return t1;
        }
        if (this.hasPath() && o.hasPath() && (t1 = this.getPath().compareTo(o.getPath())) != 0) {
            return t1;
        }
        if (this.hasFullRevision() && o.hasFullRevision() && (t1 = this.getFullRevision().compareTo(o.getFullRevision())) != 0) {
            return t1;
        }
        if (this.hasMajorRevision() && o.hasMajorRevision() && (t1 = this.getMajorRevision().compareTo(o.getMajorRevision())) != 0) {
            return t1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this.getClass().getSimpleName());
        if (this.hasAndroidVersion()) {
            builder.append(" Android=").append(this.getAndroidVersion());
        }
        if (this.hasPath()) {
            builder.append(" Path=").append(this.getPath());
        }
        if (this.hasFullRevision()) {
            builder.append(" FullRev=").append(this.getFullRevision());
        }
        if (this.hasMajorRevision()) {
            builder.append(" MajorRev=").append(this.getMajorRevision());
        }
        builder.append(">");
        return builder.toString();
    }

    public boolean hasLoadError() {
        return this.mLoadError != null;
    }

    void appendLoadError(@NonNull String format, Object ... params) {
        String loadError = String.format(format, params);
        this.mLoadError = this.mLoadError == null ? loadError : this.mLoadError + '\n' + loadError;
    }

    void setPackage(@Nullable Package pkg) {
        this.mPackage = pkg;
    }

    @Nullable
    public Package getPackage() {
        return this.mPackage;
    }

    @Override
    @NonNull
    public String getListDescription() {
        Package pkg = this.getPackage();
        return pkg == null ? "" : pkg.getListDescription();
    }
}

