/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;

public abstract class AndroidTargetHash {
    private static final String PLATFORM_HASH_PREFIX = "android-";
    public static final String ADD_ON_FORMAT = "%s:%s:%s";
    static final String PLATFORM_HASH = "android-%s";

    @NonNull
    public static String getPlatformHashString(@NonNull AndroidVersion version) {
        return String.format(PLATFORM_HASH, version.getApiString());
    }

    @Nullable
    public static AndroidVersion getPlatformVersion(@NonNull String hashString) {
        String suffix;
        if (hashString.startsWith(PLATFORM_HASH_PREFIX) && !(suffix = hashString.substring(PLATFORM_HASH_PREFIX.length())).isEmpty()) {
            if (Character.isDigit(suffix.charAt(0))) {
                int api = Integer.parseInt(suffix);
                return new AndroidVersion(api, null);
            }
            return new AndroidVersion(1, suffix);
        }
        return null;
    }

    public static String getAddonHashString(@NonNull String addonVendor, @NonNull String addonName, @NonNull AndroidVersion version) {
        return String.format(ADD_ON_FORMAT, addonVendor, addonName, version.getApiString());
    }

    public static String getTargetHashString(@NonNull IAndroidTarget target) {
        if (target.isPlatform()) {
            return AndroidTargetHash.getPlatformHashString(target.getVersion());
        }
        return AndroidTargetHash.getAddonHashString(target.getVendor(), target.getName(), target.getVersion());
    }

    public static boolean isPlatform(@NonNull String hashString) {
        return hashString.startsWith(PLATFORM_HASH_PREFIX);
    }
}

