/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.internal.AaptRunner;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergeWriter;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.resources.ResourceFolderType;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedResourceWriter
extends MergeWriter<ResourceItem> {
    private static final String FN_VALUES_XML = "values.xml";
    @Nullable
    private final AaptRunner mAaptRunner;
    private ListMultimap<String, ResourceItem> mValuesResMap;
    private Set<String> mQualifierWithDeletedValues;

    public MergedResourceWriter(@NonNull File rootFolder, @Nullable AaptRunner aaptRunner) {
        super(rootFolder);
        this.mAaptRunner = aaptRunner;
    }

    @Override
    public void start() throws MergeConsumer.ConsumerException {
        super.start();
        this.mValuesResMap = ArrayListMultimap.create();
        this.mQualifierWithDeletedValues = Sets.newHashSet();
    }

    @Override
    public void end() throws MergeConsumer.ConsumerException {
        super.end();
        this.mValuesResMap = null;
        this.mQualifierWithDeletedValues = null;
    }

    @Override
    public void addItem(final @NonNull ResourceItem item) throws MergeConsumer.ConsumerException {
        DataFile.FileType type = ((ResourceFile)item.getSource()).getType();
        if (type == DataFile.FileType.MULTI) {
            this.mValuesResMap.put((Object)((ResourceFile)item.getSource()).getQualifiers(), (Object)item);
        } else if (item.isTouched()) {
            this.getExecutor().execute(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ResourceFile resourceFile = (ResourceFile)item.getSource();
                    File file = resourceFile.getFile();
                    String filename = file.getName();
                    String folderName = item.getType().getName();
                    String qualifiers = resourceFile.getQualifiers();
                    if (!qualifiers.isEmpty()) {
                        folderName = folderName + "-" + qualifiers;
                    }
                    File typeFolder = new File(MergedResourceWriter.this.getRootFolder(), folderName);
                    MergedResourceWriter.this.createDir(typeFolder);
                    File outFile = new File(typeFolder, filename);
                    if (MergedResourceWriter.this.mAaptRunner != null && filename.endsWith(".9.png")) {
                        MergedResourceWriter.this.mAaptRunner.crunchPng(file, outFile);
                    } else {
                        Files.copy((File)file, (File)outFile);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void removeItem(@NonNull ResourceItem removedItem, @Nullable ResourceItem replacedBy) throws MergeConsumer.ConsumerException {
        DataFile.FileType replacedType;
        DataFile.FileType removedType = ((ResourceFile)removedItem.getSource()).getType();
        DataFile.FileType fileType = replacedType = replacedBy != null ? ((ResourceFile)replacedBy.getSource()).getType() : null;
        if (removedType == replacedType) {
            if (removedType == DataFile.FileType.MULTI) {
                this.mQualifierWithDeletedValues.add(((ResourceFile)removedItem.getSource()).getQualifiers());
            }
        } else if (removedType == DataFile.FileType.SINGLE) {
            this.removeOutFile((ResourceFile)removedItem.getSource());
        } else {
            this.mQualifierWithDeletedValues.add(((ResourceFile)removedItem.getSource()).getQualifiers());
        }
    }

    @Override
    protected void postWriteAction() throws MergeConsumer.ConsumerException {
        for (String key : this.mValuesResMap.keySet()) {
            boolean mustWriteFile = this.mQualifierWithDeletedValues.remove(key);
            List items = this.mValuesResMap.get((Object)key);
            if (!mustWriteFile) {
                for (ResourceItem item : items) {
                    if (!item.isTouched()) continue;
                    mustWriteFile = true;
                    break;
                }
            }
            if (!mustWriteFile) continue;
            String folderName = key.isEmpty() ? ResourceFolderType.VALUES.getName() : ResourceFolderType.VALUES.getName() + "-" + key;
            try {
                File valuesFolder = new File(this.getRootFolder(), folderName);
                this.createDir(valuesFolder);
                File outFile = new File(valuesFolder, FN_VALUES_XML);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element rootNode = document.createElement("resources");
                document.appendChild(rootNode);
                Collections.sort(items);
                for (ResourceItem item : items) {
                    Node adoptedNode = NodeUtils.adoptNode(document, item.getValue());
                    rootNode.appendChild(adoptedNode);
                }
                String content = XmlPrettyPrinter.prettyPrint(document, true);
                Files.write((CharSequence)content, (File)outFile, (Charset)Charsets.UTF_8);
            }
            catch (Throwable t) {
                throw new MergeConsumer.ConsumerException(t);
            }
        }
        for (String key : this.mQualifierWithDeletedValues) {
            String folderName = key != null && !key.isEmpty() ? ResourceFolderType.VALUES.getName() + "-" + key : ResourceFolderType.VALUES.getName();
            this.removeOutFile(folderName, FN_VALUES_XML);
        }
    }

    private boolean removeOutFile(ResourceFile resourceFile) {
        if (resourceFile.getType() == DataFile.FileType.MULTI) {
            throw new IllegalArgumentException("SourceFile cannot be a FileType.MULTI");
        }
        File file = resourceFile.getFile();
        String fileName = file.getName();
        String folderName = file.getParentFile().getName();
        return this.removeOutFile(folderName, fileName);
    }

    private boolean removeOutFile(String folderName, String fileName) {
        File valuesFolder = new File(this.getRootFolder(), folderName);
        File outFile = new File(valuesFolder, fileName);
        return outFile.delete();
    }

    private synchronized void createDir(File folder) throws IOException {
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("Failed to create directory: " + folder);
        }
    }
}

