/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.DataItem;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

abstract class DataFile<I extends DataItem> {
    private final FileType mType;
    private final File mFile;
    private final Map<String, I> mItems = Maps.newHashMap();

    DataFile(@NonNull File file, FileType fileType) {
        this.mType = fileType;
        this.mFile = file;
    }

    protected final void init(@NonNull I item) {
        ((DataItem)item).setSource((DataFile)this);
        this.mItems.put(((DataItem)item).getKey(), item);
    }

    protected void init(@NonNull List<I> items) {
        for (DataItem item : items) {
            item.setSource(this);
            this.mItems.put(item.getKey(), item);
        }
    }

    @NonNull
    FileType getType() {
        return this.mType;
    }

    @NonNull
    File getFile() {
        return this.mFile;
    }

    I getItem() {
        assert (this.mItems.size() == 1);
        return (I)((DataItem)this.mItems.values().iterator().next());
    }

    @NonNull
    Collection<I> getItems() {
        return this.mItems.values();
    }

    @NonNull
    Map<String, I> getItemMap() {
        return this.mItems;
    }

    void addItems(Collection<I> items) {
        for (DataItem item : items) {
            this.mItems.put(item.getKey(), item);
            item.setSource(this);
        }
    }

    void addExtraAttributes(Document document, Node node, String namespaceUri) {
    }

    public String toString() {
        return "DataFile{mFile=" + this.mFile + '}';
    }

    static enum FileType {
        SINGLE,
        MULTI;

    }
}

