/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class WaitableExecutor<T> {
    private final CompletionService<T> mCompletionService;
    private int mCount = 0;

    public WaitableExecutor(int nThreads) {
        this.mCompletionService = nThreads < 1 ? new ExecutorCompletionService<T>(Executors.newCachedThreadPool()) : new ExecutorCompletionService<T>(Executors.newFixedThreadPool(nThreads));
    }

    public WaitableExecutor() {
        this(0);
    }

    public void execute(Callable<T> runnable) {
        this.mCompletionService.submit(runnable);
        ++this.mCount;
    }

    public List<T> waitForTasksWithQuickFail() throws InterruptedException, ExecutionException {
        ArrayList results = Lists.newArrayListWithCapacity((int)this.mCount);
        for (int i = 0; i < this.mCount; ++i) {
            Future<T> result = this.mCompletionService.take();
            results.add(result.get());
        }
        return results;
    }

    public List<TaskResult<T>> waitForAllTasks() throws InterruptedException {
        ArrayList results = Lists.newArrayListWithCapacity((int)this.mCount);
        for (int i = 0; i < this.mCount; ++i) {
            Future<T> task = this.mCompletionService.take();
            try {
                results.add(TaskResult.withValue(task.get()));
                continue;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof InterruptedException) continue;
                results.add(new TaskResult(cause));
            }
        }
        return results;
    }

    public void cancelAllTasks() {
        Future<T> task;
        while ((task = this.mCompletionService.poll()) != null) {
            task.cancel(true);
        }
    }

    public static final class TaskResult<T> {
        public T value;
        public Throwable exception;

        static <T> TaskResult<T> withValue(T value) {
            TaskResult<T> result = new TaskResult<T>(null);
            result.value = value;
            return result;
        }

        TaskResult(Throwable cause) {
            this.exception = cause;
        }
    }
}

