/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum LayoutDirection implements ResourceEnum
{
    LTR("ldltr", "LTR", "Left To Right"),
    RTL("ldrtl", "RTL", "Right To Left");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private LayoutDirection(String value, String shortDisplayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = shortDisplayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static LayoutDirection getEnum(String value) {
        for (LayoutDirection orient : LayoutDirection.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(LayoutDirection orientation) {
        int i = 0;
        for (LayoutDirection orient : LayoutDirection.values()) {
            if (orient == orientation) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static LayoutDirection getByIndex(int index) {
        int i = 0;
        for (LayoutDirection orient : LayoutDirection.values()) {
            if (i == index) {
                return orient;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

