/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.util.List;
import lombok.ast.libs.org.parboiled.asm.ClassWriter;
import lombok.ast.libs.org.parboiled.google.collect.ImmutableList;
import lombok.ast.libs.org.parboiled.transform.ActionClassGenerator;
import lombok.ast.libs.org.parboiled.transform.AsmUtils;
import lombok.ast.libs.org.parboiled.transform.BodyWithSuperCallReplacer;
import lombok.ast.libs.org.parboiled.transform.CachingGenerator;
import lombok.ast.libs.org.parboiled.transform.CaptureClassGenerator;
import lombok.ast.libs.org.parboiled.transform.ClassNodeInitializer;
import lombok.ast.libs.org.parboiled.transform.ConstructorGenerator;
import lombok.ast.libs.org.parboiled.transform.ImplicitActionsConverter;
import lombok.ast.libs.org.parboiled.transform.InstructionGraphCreator;
import lombok.ast.libs.org.parboiled.transform.InstructionGroupCreator;
import lombok.ast.libs.org.parboiled.transform.InstructionGroupPreparer;
import lombok.ast.libs.org.parboiled.transform.LabellingGenerator;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.ReturnInstructionUnifier;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import lombok.ast.libs.org.parboiled.transform.RuleMethodRewriter;
import lombok.ast.libs.org.parboiled.transform.SkipNodeGenerator;
import lombok.ast.libs.org.parboiled.transform.SuperCallRewriter;
import lombok.ast.libs.org.parboiled.transform.SuppressNodeGenerator;
import lombok.ast.libs.org.parboiled.transform.UnusedLabelsRemover;
import lombok.ast.libs.org.parboiled.transform.VarFramingGenerator;
import lombok.ast.libs.org.parboiled.transform.VarInitClassGenerator;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserTransformer {
    private static final Object lock = new Object();

    private ParserTransformer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<? extends T> transformParser(@NotNull Class<T> parserClass) throws Exception {
        if (parserClass == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.ParserTransformer.transformParser(...) corresponds to @NotNull parameter and must not be null");
        }
        Object object = lock;
        synchronized (object) {
            Class<?> extendedClass = AsmUtils.findLoadedClass(AsmUtils.getExtendedParserClassName(parserClass.getName()), parserClass.getClassLoader());
            return extendedClass != null ? extendedClass : ParserTransformer.extendParserClass(parserClass).getExtendedClass();
        }
    }

    static ParserClassNode extendParserClass(Class<?> parserClass) throws Exception {
        ParserClassNode classNode = new ParserClassNode(parserClass);
        new ClassNodeInitializer().process(classNode);
        ParserTransformer.runMethodTransformers(classNode);
        new ConstructorGenerator().process(classNode);
        ParserTransformer.defineExtendedParserClass(classNode);
        return classNode;
    }

    private static void runMethodTransformers(ParserClassNode classNode) throws Exception {
        List<RuleMethodProcessor> methodProcessors = ParserTransformer.createRuleMethodProcessors();
        for (RuleMethod ruleMethod : classNode.getRuleMethods().values()) {
            for (RuleMethodProcessor methodProcessor : methodProcessors) {
                if (!methodProcessor.appliesTo(classNode, ruleMethod)) continue;
                methodProcessor.process(classNode, ruleMethod);
            }
        }
        for (RuleMethod ruleMethod : classNode.getRuleMethods().values()) {
            if (ruleMethod.isGenerationSkipped()) continue;
            classNode.methods.add(ruleMethod);
        }
    }

    static List<RuleMethodProcessor> createRuleMethodProcessors() {
        return ImmutableList.of(new UnusedLabelsRemover(), new ReturnInstructionUnifier(), new InstructionGraphCreator(), new ImplicitActionsConverter(), new InstructionGroupCreator(), new InstructionGroupPreparer(), new ActionClassGenerator(false), new CaptureClassGenerator(false), new VarInitClassGenerator(false), new RuleMethodRewriter(), new SuperCallRewriter(), new BodyWithSuperCallReplacer(), new VarFramingGenerator(), new LabellingGenerator(), new SuppressNodeGenerator(), new SkipNodeGenerator(), new CachingGenerator());
    }

    private static void defineExtendedParserClass(ParserClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept(classWriter);
        classNode.setClassCode(classWriter.toByteArray());
        classNode.setExtendedClass(AsmUtils.loadClass(classNode.name.replace('/', '.'), classNode.getClassCode(), classNode.getParentClass().getClassLoader()));
    }
}

