/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.tapmessage;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import net.spy.memcached.CachedData;
import net.spy.memcached.tapmessage.BaseMessage;
import net.spy.memcached.tapmessage.TapOpcode;
import net.spy.memcached.tapmessage.TapResponseFlag;
import net.spy.memcached.transcoders.SerializingTranscoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseMessage
extends BaseMessage {
    private static final int ENGINE_PRIVATE_OFFSET = 24;
    private static final int FLAGS_OFFSET = 26;
    private static final int TTL_OFFSET = 28;
    private static final int RESERVED1_OFFSET = 29;
    private static final int RESERVED2_OFFSET = 30;
    private static final int RESERVED3_OFFSET = 31;
    private static final int ITEM_FLAGS_OFFSET = 32;
    private static final int ITEM_EXPIRY_OFFSET = 36;
    private static final int KEY_OFFSET = 40;
    private final short engineprivate;
    private final List<TapResponseFlag> flags;
    private final byte ttl;
    private final byte reserved1;
    private final byte reserved2;
    private final byte reserved3;
    private final int itemflags;
    private int itemexpiry;
    private final int vbucketstate;
    private final byte[] key;
    private final byte[] value;
    private final byte[] revid;

    public ResponseMessage(byte[] b) {
        super(b);
        if (!this.opcode.equals((Object)TapOpcode.NOOP)) {
            this.engineprivate = this.decodeShort(b, 24);
            this.flags = TapResponseFlag.getFlags(this.decodeShort(b, 26));
            this.ttl = b[28];
            this.reserved1 = b[29];
            this.reserved2 = b[30];
            this.reserved3 = b[31];
        } else {
            this.engineprivate = 0;
            this.flags = new LinkedList<TapResponseFlag>();
            this.ttl = 0;
            this.reserved1 = 0;
            this.reserved2 = 0;
            this.reserved3 = 0;
        }
        if (this.opcode.equals((Object)TapOpcode.MUTATION)) {
            this.itemflags = this.flags.contains((Object)TapResponseFlag.TAP_FLAG_NETWORK_BYTE_ORDER) ? this.decodeInt(b, 32) : this.decodeIntHostOrder(b, 32);
            this.itemexpiry = this.decodeInt(b, 36);
            this.vbucketstate = 0;
            this.revid = new byte[this.engineprivate];
            System.arraycopy(b, 40, this.revid, 0, this.engineprivate);
            this.key = new byte[this.keylength];
            System.arraycopy(b, 40 + this.engineprivate, this.key, 0, this.keylength);
            this.value = new byte[b.length - this.keylength - this.engineprivate - 40];
            System.arraycopy(b, b.length - this.value.length, this.value, 0, this.value.length);
        } else if (this.opcode.equals((Object)TapOpcode.DELETE)) {
            this.itemflags = 0;
            this.itemexpiry = 0;
            this.vbucketstate = 0;
            this.key = new byte[this.keylength];
            System.arraycopy(b, 32, this.key, 0, this.keylength);
            this.value = new byte[0];
            this.revid = new byte[0];
        } else if (this.opcode.equals((Object)TapOpcode.VBUCKETSET)) {
            this.itemflags = 0;
            this.itemexpiry = 0;
            this.vbucketstate = this.decodeInt(b, 32);
            this.key = new byte[0];
            this.value = new byte[0];
            this.revid = new byte[0];
        } else {
            this.itemflags = 0;
            this.itemexpiry = 0;
            this.vbucketstate = 0;
            this.key = new byte[0];
            this.value = new byte[0];
            this.revid = new byte[0];
        }
    }

    public long getEnginePrivate() {
        return this.engineprivate;
    }

    public List<TapResponseFlag> getFlags() {
        return this.flags;
    }

    public int getTTL() {
        return this.ttl;
    }

    protected int getReserved1() {
        return this.reserved1;
    }

    protected int getReserved2() {
        return this.reserved2;
    }

    protected int getReserved3() {
        return this.reserved3;
    }

    public int getVBucketState() {
        return this.vbucketstate;
    }

    public int getItemFlags() {
        return this.itemflags;
    }

    public long getItemExpiry() {
        return this.itemexpiry;
    }

    public String getKey() {
        return new String(this.key);
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getRevID() {
        return this.revid;
    }

    @Override
    public ByteBuffer getBytes() {
        int bufSize = 0;
        bufSize += 24;
        if (this.opcode.equals((Object)TapOpcode.MUTATION)) {
            bufSize += 16;
        }
        ByteBuffer bb = ByteBuffer.allocate(bufSize += this.getTotalbody());
        bb.put(this.magic.getMagic());
        bb.put(this.opcode.getOpcode());
        bb.putShort(this.keylength);
        bb.put(this.extralength);
        bb.put(this.datatype);
        bb.putShort(this.vbucket);
        bb.putInt(this.totalbody);
        bb.putInt(this.opaque);
        bb.putLong(this.cas);
        if (this.opcode.equals((Object)TapOpcode.NOOP)) {
            return bb;
        }
        bb.putShort(this.engineprivate);
        short flag = 0;
        for (int i = 0; i < this.flags.size(); ++i) {
            flag = (short)(flag | this.flags.get(i).getFlags());
        }
        bb.putShort(flag);
        bb.put(this.ttl);
        bb.put(this.reserved1);
        bb.put(this.reserved2);
        bb.put(this.reserved3);
        if (this.opcode.equals((Object)TapOpcode.MUTATION)) {
            bb.putInt(this.itemflags);
            bb.putInt(this.itemexpiry);
            bb.put(this.revid);
            bb.put(this.key);
            bb.put(this.value);
        } else if (this.opcode.equals((Object)TapOpcode.DELETE)) {
            bb.put(this.key);
        } else if (this.opcode.equals((Object)TapOpcode.VBUCKETSET)) {
            bb.putInt(this.vbucketstate);
        }
        return bb;
    }

    public String toString() {
        return String.format("Key: %s, Flags: %d, TTL: %d, Size: %d\nValue: %s", this.getKey(), this.getItemFlags(), this.getTTL(), this.getValue().length, this.deserialize());
    }

    private Object deserialize() {
        SerializingTranscoder tc = new SerializingTranscoder();
        CachedData d = new CachedData(this.getItemFlags(), this.getValue(), 0x1400000);
        Object rv = null;
        rv = tc.decode(d);
        return rv;
    }
}

