/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.spring;

import java.util.Collection;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.ops.OperationQueueFactory;
import net.spy.memcached.transcoders.Transcoder;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedClientFactoryBean
implements FactoryBean {
    private final ConnectionFactoryBuilder connectionFactoryBuilder = new ConnectionFactoryBuilder();
    private String servers;

    public Object getObject() throws Exception {
        return new MemcachedClient(this.connectionFactoryBuilder.build(), AddrUtil.getAddresses(this.servers));
    }

    public Class<?> getObjectType() {
        return MemcachedClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setServers(String newServers) {
        this.servers = newServers;
    }

    public void setAuthDescriptor(AuthDescriptor to) {
        this.connectionFactoryBuilder.setAuthDescriptor(to);
    }

    public void setDaemon(boolean d) {
        this.connectionFactoryBuilder.setDaemon(d);
    }

    public void setFailureMode(FailureMode fm) {
        this.connectionFactoryBuilder.setFailureMode(fm);
    }

    public void setHashAlg(HashAlgorithm to) {
        this.connectionFactoryBuilder.setHashAlg(to);
    }

    public void setInitialObservers(Collection<ConnectionObserver> obs) {
        this.connectionFactoryBuilder.setInitialObservers(obs);
    }

    public void setLocatorType(ConnectionFactoryBuilder.Locator l) {
        this.connectionFactoryBuilder.setLocatorType(l);
    }

    public void setMaxReconnectDelay(long to) {
        this.connectionFactoryBuilder.setMaxReconnectDelay(to);
    }

    public void setOpFact(OperationFactory f) {
        this.connectionFactoryBuilder.setOpFact(f);
    }

    public void setOpQueueFactory(OperationQueueFactory q) {
        this.connectionFactoryBuilder.setOpQueueFactory(q);
    }

    public void setOpQueueMaxBlockTime(long t) {
        this.connectionFactoryBuilder.setOpQueueMaxBlockTime(t);
    }

    public void setOpTimeout(long t) {
        this.connectionFactoryBuilder.setOpTimeout(t);
    }

    public void setProtocol(ConnectionFactoryBuilder.Protocol prot) {
        this.connectionFactoryBuilder.setProtocol(prot);
    }

    public void setReadBufferSize(int to) {
        this.connectionFactoryBuilder.setReadBufferSize(to);
    }

    public void setReadOpQueueFactory(OperationQueueFactory q) {
        this.connectionFactoryBuilder.setReadOpQueueFactory(q);
    }

    public void setShouldOptimize(boolean o) {
        this.connectionFactoryBuilder.setShouldOptimize(o);
    }

    public void setTimeoutExceptionThreshold(int to) {
        this.connectionFactoryBuilder.setTimeoutExceptionThreshold(to);
    }

    public void setTranscoder(Transcoder<Object> t) {
        this.connectionFactoryBuilder.setTranscoder(t);
    }

    public void setUseNagleAlgorithm(boolean to) {
        this.connectionFactoryBuilder.setUseNagleAlgorithm(to);
    }

    public void setWriteOpQueueFactory(OperationQueueFactory q) {
        this.connectionFactoryBuilder.setWriteOpQueueFactory(q);
    }
}

