/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.spy.memcached.config.ClusterConfiguration;
import net.spy.memcached.config.NodeEndPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddrUtil {
    public static final char HOST_CONFIG_DELIMITER = '|';

    private AddrUtil() {
    }

    public static List<InetSocketAddress> getAddresses(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        if (s.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in list:  ``" + s + "''");
        }
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (String hoststuff : s.split("(?:\\s|,)+")) {
            if (hoststuff.equals("")) continue;
            int finalColon = hoststuff.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hoststuff + "'' in list:  " + s);
            }
            String hostPart = hoststuff.substring(0, finalColon);
            String portNum = hoststuff.substring(finalColon + 1);
            addrs.add(new InetSocketAddress(hostPart, Integer.parseInt(portNum)));
        }
        assert (!addrs.isEmpty()) : "No addrs found";
        return addrs;
    }

    public static List<InetSocketAddress> getAddresses(List<String> servers) {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>(servers.size());
        for (String server : servers) {
            int finalColon = server.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + server + "'' in list:  " + server);
            }
            String hostPart = server.substring(0, finalColon);
            String portNum = server.substring(finalColon + 1);
            addrs.add(new InetSocketAddress(hostPart, Integer.parseInt(portNum)));
        }
        if (addrs.isEmpty()) {
            throw new IllegalArgumentException("servers cannot be empty");
        }
        return addrs;
    }

    public static List<InetSocketAddress> getAddressesFromURL(List<URL> servers) {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>(servers.size());
        for (URL server : servers) {
            addrs.add(new InetSocketAddress(server.getHost(), server.getPort()));
        }
        return addrs;
    }

    public static ClusterConfiguration parseClusterTypeConfiguration(String configurationResponse) {
        if (configurationResponse == null) {
            throw new NullPointerException("Null configuration");
        }
        if (configurationResponse.trim().equals("")) {
            throw new IllegalArgumentException("No configuration in the response:" + configurationResponse);
        }
        String[] lines = configurationResponse.trim().split("(?:\\r?\\n)");
        if (lines == null || lines.length != 2) {
            throw new IllegalArgumentException("Incorrect response format. Response:" + configurationResponse);
        }
        String versionString = lines[0].trim();
        if (versionString.equals("")) {
            throw new IllegalArgumentException("Version number is missing. Response:" + configurationResponse);
        }
        long versionNumber = Long.parseLong(versionString);
        String hostList = lines[1].trim();
        if (hostList.equals("")) {
            throw new IllegalArgumentException("Empty host list in the response:" + configurationResponse);
        }
        ArrayList<NodeEndPoint> endPoints = new ArrayList<NodeEndPoint>();
        for (String hostDetails : hostList.split("(?:\\s)+")) {
            if (hostDetails.equals("")) continue;
            int firstDelimiter = hostDetails.indexOf(124);
            int secondDelimiter = hostDetails.lastIndexOf(124);
            if (firstDelimiter < 1 || firstDelimiter == secondDelimiter) {
                throw new IllegalArgumentException("Invalid server ''" + hostDetails + "'' in response:  " + configurationResponse);
            }
            String hostName = hostDetails.substring(0, firstDelimiter).trim();
            String ipAddress = hostDetails.substring(firstDelimiter + 1, secondDelimiter).trim();
            String portNum = hostDetails.substring(secondDelimiter + 1).trim();
            int port = Integer.parseInt(portNum);
            NodeEndPoint endPoint = new NodeEndPoint(hostName, ipAddress, port);
            endPoints.add(endPoint);
        }
        assert (!endPoints.isEmpty()) : "No endpoints found";
        ClusterConfiguration config = new ClusterConfiguration(versionNumber, endPoints);
        return config;
    }
}

