/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeWorkspacesConnectionStatusRequestMarshaller
implements Marshaller<Request<DescribeWorkspacesConnectionStatusRequest>, DescribeWorkspacesConnectionStatusRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeWorkspacesConnectionStatusRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeWorkspacesConnectionStatusRequest> marshall(DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest) {
        if (describeWorkspacesConnectionStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeWorkspacesConnectionStatusRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.DescribeWorkspacesConnectionStatus");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList workspaceIdsList = (SdkInternalList)describeWorkspacesConnectionStatusRequest.getWorkspaceIds();
            if (!workspaceIdsList.isEmpty() || !workspaceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("WorkspaceIds");
                jsonGenerator.writeStartArray();
                for (String workspaceIdsListValue : workspaceIdsList) {
                    if (workspaceIdsListValue == null) continue;
                    jsonGenerator.writeValue(workspaceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeWorkspacesConnectionStatusRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeWorkspacesConnectionStatusRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

