/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.ByteMatchSetUpdate;
import com.amazonaws.services.waf.model.UpdateByteMatchSetRequest;
import com.amazonaws.services.waf.model.transform.ByteMatchSetUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateByteMatchSetRequestMarshaller
implements Marshaller<Request<UpdateByteMatchSetRequest>, UpdateByteMatchSetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateByteMatchSetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateByteMatchSetRequest> marshall(UpdateByteMatchSetRequest updateByteMatchSetRequest) {
        if (updateByteMatchSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateByteMatchSetRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.UpdateByteMatchSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<ByteMatchSetUpdate> updatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateByteMatchSetRequest.getByteMatchSetId() != null) {
                jsonGenerator.writeFieldName("ByteMatchSetId").writeValue(updateByteMatchSetRequest.getByteMatchSetId());
            }
            if (updateByteMatchSetRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(updateByteMatchSetRequest.getChangeToken());
            }
            if ((updatesList = updateByteMatchSetRequest.getUpdates()) != null) {
                jsonGenerator.writeFieldName("Updates");
                jsonGenerator.writeStartArray();
                for (ByteMatchSetUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    ByteMatchSetUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

