/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.timestreamquery.model.DimensionMapping;
import com.amazonaws.services.timestreamquery.model.MixedMeasureMapping;
import com.amazonaws.services.timestreamquery.model.MultiMeasureMappings;
import com.amazonaws.services.timestreamquery.model.transform.TimestreamConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TimestreamConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String databaseName;
    private String tableName;
    private String timeColumn;
    private List<DimensionMapping> dimensionMappings;
    private MultiMeasureMappings multiMeasureMappings;
    private List<MixedMeasureMapping> mixedMeasureMappings;
    private String measureNameColumn;

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public TimestreamConfiguration withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TimestreamConfiguration withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public void setTimeColumn(String timeColumn) {
        this.timeColumn = timeColumn;
    }

    public String getTimeColumn() {
        return this.timeColumn;
    }

    public TimestreamConfiguration withTimeColumn(String timeColumn) {
        this.setTimeColumn(timeColumn);
        return this;
    }

    public List<DimensionMapping> getDimensionMappings() {
        return this.dimensionMappings;
    }

    public void setDimensionMappings(Collection<DimensionMapping> dimensionMappings) {
        if (dimensionMappings == null) {
            this.dimensionMappings = null;
            return;
        }
        this.dimensionMappings = new ArrayList<DimensionMapping>(dimensionMappings);
    }

    public TimestreamConfiguration withDimensionMappings(DimensionMapping ... dimensionMappings) {
        if (this.dimensionMappings == null) {
            this.setDimensionMappings(new ArrayList<DimensionMapping>(dimensionMappings.length));
        }
        for (DimensionMapping ele : dimensionMappings) {
            this.dimensionMappings.add(ele);
        }
        return this;
    }

    public TimestreamConfiguration withDimensionMappings(Collection<DimensionMapping> dimensionMappings) {
        this.setDimensionMappings(dimensionMappings);
        return this;
    }

    public void setMultiMeasureMappings(MultiMeasureMappings multiMeasureMappings) {
        this.multiMeasureMappings = multiMeasureMappings;
    }

    public MultiMeasureMappings getMultiMeasureMappings() {
        return this.multiMeasureMappings;
    }

    public TimestreamConfiguration withMultiMeasureMappings(MultiMeasureMappings multiMeasureMappings) {
        this.setMultiMeasureMappings(multiMeasureMappings);
        return this;
    }

    public List<MixedMeasureMapping> getMixedMeasureMappings() {
        return this.mixedMeasureMappings;
    }

    public void setMixedMeasureMappings(Collection<MixedMeasureMapping> mixedMeasureMappings) {
        if (mixedMeasureMappings == null) {
            this.mixedMeasureMappings = null;
            return;
        }
        this.mixedMeasureMappings = new ArrayList<MixedMeasureMapping>(mixedMeasureMappings);
    }

    public TimestreamConfiguration withMixedMeasureMappings(MixedMeasureMapping ... mixedMeasureMappings) {
        if (this.mixedMeasureMappings == null) {
            this.setMixedMeasureMappings(new ArrayList<MixedMeasureMapping>(mixedMeasureMappings.length));
        }
        for (MixedMeasureMapping ele : mixedMeasureMappings) {
            this.mixedMeasureMappings.add(ele);
        }
        return this;
    }

    public TimestreamConfiguration withMixedMeasureMappings(Collection<MixedMeasureMapping> mixedMeasureMappings) {
        this.setMixedMeasureMappings(mixedMeasureMappings);
        return this;
    }

    public void setMeasureNameColumn(String measureNameColumn) {
        this.measureNameColumn = measureNameColumn;
    }

    public String getMeasureNameColumn() {
        return this.measureNameColumn;
    }

    public TimestreamConfiguration withMeasureNameColumn(String measureNameColumn) {
        this.setMeasureNameColumn(measureNameColumn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getTimeColumn() != null) {
            sb.append("TimeColumn: ").append(this.getTimeColumn()).append(",");
        }
        if (this.getDimensionMappings() != null) {
            sb.append("DimensionMappings: ").append(this.getDimensionMappings()).append(",");
        }
        if (this.getMultiMeasureMappings() != null) {
            sb.append("MultiMeasureMappings: ").append(this.getMultiMeasureMappings()).append(",");
        }
        if (this.getMixedMeasureMappings() != null) {
            sb.append("MixedMeasureMappings: ").append(this.getMixedMeasureMappings()).append(",");
        }
        if (this.getMeasureNameColumn() != null) {
            sb.append("MeasureNameColumn: ").append(this.getMeasureNameColumn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamConfiguration)) {
            return false;
        }
        TimestreamConfiguration other = (TimestreamConfiguration)obj;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getTimeColumn() == null ^ this.getTimeColumn() == null) {
            return false;
        }
        if (other.getTimeColumn() != null && !other.getTimeColumn().equals(this.getTimeColumn())) {
            return false;
        }
        if (other.getDimensionMappings() == null ^ this.getDimensionMappings() == null) {
            return false;
        }
        if (other.getDimensionMappings() != null && !other.getDimensionMappings().equals(this.getDimensionMappings())) {
            return false;
        }
        if (other.getMultiMeasureMappings() == null ^ this.getMultiMeasureMappings() == null) {
            return false;
        }
        if (other.getMultiMeasureMappings() != null && !other.getMultiMeasureMappings().equals(this.getMultiMeasureMappings())) {
            return false;
        }
        if (other.getMixedMeasureMappings() == null ^ this.getMixedMeasureMappings() == null) {
            return false;
        }
        if (other.getMixedMeasureMappings() != null && !other.getMixedMeasureMappings().equals(this.getMixedMeasureMappings())) {
            return false;
        }
        if (other.getMeasureNameColumn() == null ^ this.getMeasureNameColumn() == null) {
            return false;
        }
        return other.getMeasureNameColumn() == null || other.getMeasureNameColumn().equals(this.getMeasureNameColumn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getTimeColumn() == null ? 0 : this.getTimeColumn().hashCode());
        hashCode = 31 * hashCode + (this.getDimensionMappings() == null ? 0 : this.getDimensionMappings().hashCode());
        hashCode = 31 * hashCode + (this.getMultiMeasureMappings() == null ? 0 : this.getMultiMeasureMappings().hashCode());
        hashCode = 31 * hashCode + (this.getMixedMeasureMappings() == null ? 0 : this.getMixedMeasureMappings().hashCode());
        hashCode = 31 * hashCode + (this.getMeasureNameColumn() == null ? 0 : this.getMeasureNameColumn().hashCode());
        return hashCode;
    }

    public TimestreamConfiguration clone() {
        try {
            return (TimestreamConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimestreamConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

