/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssmincidents;

import javax.annotation.Generated;

import com.amazonaws.services.ssmincidents.model.*;
import com.amazonaws.*;
import com.amazonaws.services.ssmincidents.waiters.AWSSSMIncidentsWaiters;

/**
 * Abstract implementation of {@code AWSSSMIncidents}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSSMIncidents implements AWSSSMIncidents {

    protected AbstractAWSSSMIncidents() {
    }

    @Override
    public BatchGetIncidentFindingsResult batchGetIncidentFindings(BatchGetIncidentFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReplicationSetResult createReplicationSet(CreateReplicationSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResponsePlanResult createResponsePlan(CreateResponsePlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTimelineEventResult createTimelineEvent(CreateTimelineEventRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIncidentRecordResult deleteIncidentRecord(DeleteIncidentRecordRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReplicationSetResult deleteReplicationSet(DeleteReplicationSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResponsePlanResult deleteResponsePlan(DeleteResponsePlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTimelineEventResult deleteTimelineEvent(DeleteTimelineEventRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIncidentRecordResult getIncidentRecord(GetIncidentRecordRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReplicationSetResult getReplicationSet(GetReplicationSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourcePoliciesResult getResourcePolicies(GetResourcePoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResponsePlanResult getResponsePlan(GetResponsePlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTimelineEventResult getTimelineEvent(GetTimelineEventRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIncidentFindingsResult listIncidentFindings(ListIncidentFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIncidentRecordsResult listIncidentRecords(ListIncidentRecordsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRelatedItemsResult listRelatedItems(ListRelatedItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReplicationSetsResult listReplicationSets(ListReplicationSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResponsePlansResult listResponsePlans(ListResponsePlansRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTimelineEventsResult listTimelineEvents(ListTimelineEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartIncidentResult startIncident(StartIncidentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeletionProtectionResult updateDeletionProtection(UpdateDeletionProtectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIncidentRecordResult updateIncidentRecord(UpdateIncidentRecordRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRelatedItemsResult updateRelatedItems(UpdateRelatedItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateReplicationSetResult updateReplicationSet(UpdateReplicationSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResponsePlanResult updateResponsePlan(UpdateResponsePlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTimelineEventResult updateTimelineEvent(UpdateTimelineEventRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AWSSSMIncidentsWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
