/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.simplesystemsmanagement.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ModifyDocumentPermissionRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ModifyDocumentPermissionRequestMarshaller {

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Name").build();
    private static final MarshallingInfo<String> PERMISSIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PermissionType").build();
    private static final MarshallingInfo<List> ACCOUNTIDSTOADD_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountIdsToAdd").build();
    private static final MarshallingInfo<List> ACCOUNTIDSTOREMOVE_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountIdsToRemove").build();
    private static final MarshallingInfo<String> SHAREDDOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SharedDocumentVersion").build();

    private static final ModifyDocumentPermissionRequestMarshaller instance = new ModifyDocumentPermissionRequestMarshaller();

    public static ModifyDocumentPermissionRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ModifyDocumentPermissionRequest modifyDocumentPermissionRequest, ProtocolMarshaller protocolMarshaller) {

        if (modifyDocumentPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(modifyDocumentPermissionRequest.getName(), NAME_BINDING);
            protocolMarshaller.marshall(modifyDocumentPermissionRequest.getPermissionType(), PERMISSIONTYPE_BINDING);
            protocolMarshaller.marshall(modifyDocumentPermissionRequest.getAccountIdsToAdd(), ACCOUNTIDSTOADD_BINDING);
            protocolMarshaller.marshall(modifyDocumentPermissionRequest.getAccountIdsToRemove(), ACCOUNTIDSTOREMOVE_BINDING);
            protocolMarshaller.marshall(modifyDocumentPermissionRequest.getSharedDocumentVersion(), SHAREDDOCUMENTVERSION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
