/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.TopicVisual;
import java.util.List;

@SdkInternalApi
public class TopicVisualMarshaller {
    private static final MarshallingInfo<String> VISUALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisualId").build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").build();
    private static final MarshallingInfo<StructuredPojo> IR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ir").build();
    private static final MarshallingInfo<List> SUPPORTINGVISUALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportingVisuals").build();
    private static final TopicVisualMarshaller instance = new TopicVisualMarshaller();

    public static TopicVisualMarshaller getInstance() {
        return instance;
    }

    public void marshall(TopicVisual topicVisual, ProtocolMarshaller protocolMarshaller) {
        if (topicVisual == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)topicVisual.getVisualId(), VISUALID_BINDING);
            protocolMarshaller.marshall((Object)topicVisual.getRole(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)topicVisual.getIr(), IR_BINDING);
            protocolMarshaller.marshall(topicVisual.getSupportingVisuals(), SUPPORTINGVISUALS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

