/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoicev2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.pinpointsmsvoicev2.model.RegistrationFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeRegistrationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> registrationIds;
    private List<RegistrationFilter> filters;
    private String nextToken;
    private Integer maxResults;

    public List<String> getRegistrationIds() {
        return this.registrationIds;
    }

    public void setRegistrationIds(Collection<String> registrationIds) {
        if (registrationIds == null) {
            this.registrationIds = null;
            return;
        }
        this.registrationIds = new ArrayList<String>(registrationIds);
    }

    public DescribeRegistrationsRequest withRegistrationIds(String ... registrationIds) {
        if (this.registrationIds == null) {
            this.setRegistrationIds(new ArrayList<String>(registrationIds.length));
        }
        for (String ele : registrationIds) {
            this.registrationIds.add(ele);
        }
        return this;
    }

    public DescribeRegistrationsRequest withRegistrationIds(Collection<String> registrationIds) {
        this.setRegistrationIds(registrationIds);
        return this;
    }

    public List<RegistrationFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<RegistrationFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<RegistrationFilter>(filters);
    }

    public DescribeRegistrationsRequest withFilters(RegistrationFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<RegistrationFilter>(filters.length));
        }
        for (RegistrationFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeRegistrationsRequest withFilters(Collection<RegistrationFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeRegistrationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeRegistrationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegistrationIds() != null) {
            sb.append("RegistrationIds: ").append(this.getRegistrationIds()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationsRequest)) {
            return false;
        }
        DescribeRegistrationsRequest other = (DescribeRegistrationsRequest)obj;
        if (other.getRegistrationIds() == null ^ this.getRegistrationIds() == null) {
            return false;
        }
        if (other.getRegistrationIds() != null && !other.getRegistrationIds().equals(this.getRegistrationIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegistrationIds() == null ? 0 : this.getRegistrationIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public DescribeRegistrationsRequest clone() {
        return (DescribeRegistrationsRequest)super.clone();
    }
}

