/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoicev2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.pinpointsmsvoicev2.model.PoolFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribePoolsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> poolIds;
    private List<PoolFilter> filters;
    private String nextToken;
    private Integer maxResults;

    public List<String> getPoolIds() {
        return this.poolIds;
    }

    public void setPoolIds(Collection<String> poolIds) {
        if (poolIds == null) {
            this.poolIds = null;
            return;
        }
        this.poolIds = new ArrayList<String>(poolIds);
    }

    public DescribePoolsRequest withPoolIds(String ... poolIds) {
        if (this.poolIds == null) {
            this.setPoolIds(new ArrayList<String>(poolIds.length));
        }
        for (String ele : poolIds) {
            this.poolIds.add(ele);
        }
        return this;
    }

    public DescribePoolsRequest withPoolIds(Collection<String> poolIds) {
        this.setPoolIds(poolIds);
        return this;
    }

    public List<PoolFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<PoolFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<PoolFilter>(filters);
    }

    public DescribePoolsRequest withFilters(PoolFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<PoolFilter>(filters.length));
        }
        for (PoolFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribePoolsRequest withFilters(Collection<PoolFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribePoolsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribePoolsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPoolIds() != null) {
            sb.append("PoolIds: ").append(this.getPoolIds()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoolsRequest)) {
            return false;
        }
        DescribePoolsRequest other = (DescribePoolsRequest)obj;
        if (other.getPoolIds() == null ^ this.getPoolIds() == null) {
            return false;
        }
        if (other.getPoolIds() != null && !other.getPoolIds().equals(this.getPoolIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPoolIds() == null ? 0 : this.getPoolIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public DescribePoolsRequest clone() {
        return (DescribePoolsRequest)super.clone();
    }
}

