/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.MatchAttributes;
import com.amazonaws.services.networkfirewall.model.transform.RuleDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RuleDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private MatchAttributes matchAttributes;
    private List<String> actions;

    public void setMatchAttributes(MatchAttributes matchAttributes) {
        this.matchAttributes = matchAttributes;
    }

    public MatchAttributes getMatchAttributes() {
        return this.matchAttributes;
    }

    public RuleDefinition withMatchAttributes(MatchAttributes matchAttributes) {
        this.setMatchAttributes(matchAttributes);
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public RuleDefinition withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public RuleDefinition withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMatchAttributes() != null) {
            sb.append("MatchAttributes: ").append(this.getMatchAttributes()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDefinition)) {
            return false;
        }
        RuleDefinition other = (RuleDefinition)obj;
        if (other.getMatchAttributes() == null ^ this.getMatchAttributes() == null) {
            return false;
        }
        if (other.getMatchAttributes() != null && !other.getMatchAttributes().equals(this.getMatchAttributes())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMatchAttributes() == null ? 0 : this.getMatchAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public RuleDefinition clone() {
        try {
            return (RuleDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

