/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import javax.annotation.Generated;

/**
 * Choose Include to have MediaConvert generate an HLS child manifest that lists only the I-frames for this rendition,
 * in addition to your regular manifest for this rendition. You might use this manifest as part of a workflow that
 * creates preview functions for your video. MediaConvert adds both the I-frame only child manifest and the regular
 * child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep the default value
 * Exclude.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum CmfcIFrameOnlyManifest {

    INCLUDE("INCLUDE"),
    EXCLUDE("EXCLUDE");

    private String value;

    private CmfcIFrameOnlyManifest(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return CmfcIFrameOnlyManifest corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static CmfcIFrameOnlyManifest fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (CmfcIFrameOnlyManifest enumEntry : CmfcIFrameOnlyManifest.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
