/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutforvision.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lookoutforvision.model.InputS3Object;

@SdkInternalApi
public class InputS3ObjectMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").build();
    private static final InputS3ObjectMarshaller instance = new InputS3ObjectMarshaller();

    public static InputS3ObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputS3Object inputS3Object, ProtocolMarshaller protocolMarshaller) {
        if (inputS3Object == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputS3Object.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)inputS3Object.getKey(), KEY_BINDING);
            protocolMarshaller.marshall((Object)inputS3Object.getVersionId(), VERSIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

