/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.frauddetector.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteEventRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the event to delete.
     * </p>
     */
    private String eventId;
    /**
     * <p>
     * The name of the event type.
     * </p>
     */
    private String eventTypeName;
    /**
     * <p>
     * Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
     * </p>
     */
    private Boolean deleteAuditHistory;

    /**
     * <p>
     * The ID of the event to delete.
     * </p>
     * 
     * @param eventId
     *        The ID of the event to delete.
     */

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    /**
     * <p>
     * The ID of the event to delete.
     * </p>
     * 
     * @return The ID of the event to delete.
     */

    public String getEventId() {
        return this.eventId;
    }

    /**
     * <p>
     * The ID of the event to delete.
     * </p>
     * 
     * @param eventId
     *        The ID of the event to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteEventRequest withEventId(String eventId) {
        setEventId(eventId);
        return this;
    }

    /**
     * <p>
     * The name of the event type.
     * </p>
     * 
     * @param eventTypeName
     *        The name of the event type.
     */

    public void setEventTypeName(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    /**
     * <p>
     * The name of the event type.
     * </p>
     * 
     * @return The name of the event type.
     */

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    /**
     * <p>
     * The name of the event type.
     * </p>
     * 
     * @param eventTypeName
     *        The name of the event type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteEventRequest withEventTypeName(String eventTypeName) {
        setEventTypeName(eventTypeName);
        return this;
    }

    /**
     * <p>
     * Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
     * </p>
     * 
     * @param deleteAuditHistory
     *        Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
     */

    public void setDeleteAuditHistory(Boolean deleteAuditHistory) {
        this.deleteAuditHistory = deleteAuditHistory;
    }

    /**
     * <p>
     * Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
     * </p>
     * 
     * @return Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>
     *         ,
     */

    public Boolean getDeleteAuditHistory() {
        return this.deleteAuditHistory;
    }

    /**
     * <p>
     * Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
     * </p>
     * 
     * @param deleteAuditHistory
     *        Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteEventRequest withDeleteAuditHistory(Boolean deleteAuditHistory) {
        setDeleteAuditHistory(deleteAuditHistory);
        return this;
    }

    /**
     * <p>
     * Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
     * </p>
     * 
     * @return Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>
     *         ,
     */

    public Boolean isDeleteAuditHistory() {
        return this.deleteAuditHistory;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEventId() != null)
            sb.append("EventId: ").append(getEventId()).append(",");
        if (getEventTypeName() != null)
            sb.append("EventTypeName: ").append(getEventTypeName()).append(",");
        if (getDeleteAuditHistory() != null)
            sb.append("DeleteAuditHistory: ").append(getDeleteAuditHistory());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteEventRequest == false)
            return false;
        DeleteEventRequest other = (DeleteEventRequest) obj;
        if (other.getEventId() == null ^ this.getEventId() == null)
            return false;
        if (other.getEventId() != null && other.getEventId().equals(this.getEventId()) == false)
            return false;
        if (other.getEventTypeName() == null ^ this.getEventTypeName() == null)
            return false;
        if (other.getEventTypeName() != null && other.getEventTypeName().equals(this.getEventTypeName()) == false)
            return false;
        if (other.getDeleteAuditHistory() == null ^ this.getDeleteAuditHistory() == null)
            return false;
        if (other.getDeleteAuditHistory() != null && other.getDeleteAuditHistory().equals(this.getDeleteAuditHistory()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEventId() == null) ? 0 : getEventId().hashCode());
        hashCode = prime * hashCode + ((getEventTypeName() == null) ? 0 : getEventTypeName().hashCode());
        hashCode = prime * hashCode + ((getDeleteAuditHistory() == null) ? 0 : getDeleteAuditHistory().hashCode());
        return hashCode;
    }

    @Override
    public DeleteEventRequest clone() {
        return (DeleteEventRequest) super.clone();
    }

}
